package org.unlaxer.jaddress.parser;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.unlaxer.jaddress.entity.standard.郵便番号;

public class ResultRegulator  implements ParsingResultMapPopulator{
	
	@Override
	public Map<String, String> apply(ParsingResult parsingResult) {
		
		Map<String, String> resultAsMap = new HashMap<>();
		resultAsMap.put("input", parsingResult.overAllAddressContext().addressString().joined());
		resultAsMap.put("zip", parsingResult.overAllAddressContext().zip().asHyphonated());
		
		parsingResult.addressElementsWithoutCheck().get().stream().forEach(addressElements -> {
			addressElements.get().forEach(addressElement -> {
				String value = addressElement.asString();
				
				if (StringUtils.isNoneBlank(value)) {
					
					resultAsMap.put(String.valueOf(addressElement.level()), value);
					addressElement.offsetOfBlock().ifPresent(offset->resultAsMap.put("bl_" + String.valueOf(offset.value()), value));
					addressElement.offsetOfBuilding().ifPresent(offset->resultAsMap.put("bd_" + String.valueOf(offset.value()), value));
				}
			});
		});
		return resultAsMap;
	}

	@Override
	public FlatResult create(ParsingResult parsingResult) {
		
		String input = parsingResult.overAllAddressContext().addressString().joined();
		郵便番号 zip = 郵便番号.fromString(parsingResult.overAllAddressContext().zip().asHyphonated());
		
		FlatResult flatResult = new FlatResult(input, zip);
		
		parsingResult.addressElementsWithoutCheck().get().stream().forEach(addressElements -> {
			addressElements.get().forEach(addressElement -> {
				String value = addressElement.asString();
				
				if (StringUtils.isNoneBlank(value)) {
					
					addressElement.階層要素().ifPresent(_階層要素->flatResult.add(_階層要素, value));
					addressElement.offsetOfBlock().ifPresent(offset->flatResult.add(offset, value));
					addressElement.offsetOfBuilding().ifPresent(offset->flatResult.add(offset, value));
				}
			});
		});
		return flatResult;
	}
	
}