package org.unlaxer.jaddress.parser;

import org.unlaxer.jaddress.entity.standard.定義済みRange階層要素;
import org.unlaxer.jaddress.entity.standard.階層要素;

public class SimpleNextStateResolverBy階層要素 implements NextStateResolverBy階層要素 {
	
	@Override
	public ParsingState apply(階層要素 _階層要素) {
		switch (_階層要素) {
		case 国域Top1:
//			case 都道府県:
//			case その他:
				break;
		case 国域Top2:
//			case 政令指定市:
//			case 東京23区:
//			case 市:
//			case 群:
				break;
		case 国域Top3:
//			case 区:
				break;
		case 国域Top4:
//			case 町または大字:
//			case 町村:
				break;
		case ダミーサフィックス:
			break;
		case 町域Top1:
			break;
		case 不明:
			break;
		case 住居番号:
			break;
		case 町域Top2:
			break;
		case 字小字:
			break;
		case 建物:
			break;
		case 町域Top3:
			break;
		case 方書き:
			break;
		case 町域Top4:
			break;
		case 建物Bottom3:
			break;
		case 空:
			break;
		case 街区符号:
			break;
		case 建物Bottom1:
			break;
		case 建物Bottom2:
			break;
		default:
			break;
		
		}
		return ParsingState.パース終了;
	}

	@Override
	public ParsingState apply(定義済みRange階層要素 _階層要素) {
		
		switch (_階層要素) {
		case 全体:
		case 都道府県から町名まで:
		case 都道府県以降から建物より前まで:
			return ParsingState.ZIPから郵便番号情報取得;
		case 丁目から枝番まで:
			return ParsingState.丁目以降を分割する;
		case 町名より後:
		case 丁目以降:
			return ParsingState.丁目以降を分割する;
		case 建物より後:
		case 建物より後部屋番号より前:
		case 建物より後部階数より前:
			return ParsingState.建物より後の分割をする;
		case 建物以降:
			return ParsingState.建物名の抜き出しをする;
		default:
			break;
		}
		throw new IllegalArgumentException(_階層要素.name());
	}
	
}