package org.unlaxer.jaddress.parser;

import java.util.function.Supplier;

import org.unlaxer.jaddress.model.StringValue;

import io.vavr.Lazy;

public class StateSpecifier extends StringValue implements Supplier<ParsingState>{

	private static final long serialVersionUID = -4210394295364826292L;
	
	final Lazy<ParsingState> state;
	
	public StateSpecifier(String value) {
		super(value);
		state = Lazy.of(()->ParsingState.valueOf(value));
	}
	
	public ParsingState get() {
		return state.get();
	}
}