package org.unlaxer.jaddress.parser;

import java.util.List;

public class StringAndCharacterKind{
	
	public  static final StringAndCharacterKind TERMINATOR = new StringAndCharacterKind(CharacterKind.terminator , "");
	
	final String string;
	final CharacterKind characterKind;
	
	public StringAndCharacterKind(CharacterKind characterKind , String string) {
		super();
		this.string = string;
		this.characterKind = characterKind;
	}
	
	public CharacterKind characterKind() {
		return characterKind;
	}
	
	public String get() {
		return string;
	}
	
	public StringAndCharacterKinds of(String word) {
		word = word.strip();
		List<StringAndCharacterKind> stringAndCharacterKindOf = StringAndCharacterKinds.of(word , false);
		return new StringAndCharacterKinds(stringAndCharacterKindOf);
	}

	@Override
	public String toString() {
		return characterKind + ":" + "\""+string+ "\"";
	}
}