package org.unlaxer.jaddress.parser;

import org.unlaxer.jaddress.model.IntegerValue;

public class StringIndex extends IntegerValue{

	private static final long serialVersionUID = 8659211772581756685L;
	
	public StringIndex(int value) {
		super(value);
	}
	
	public static StringIndex of(int index) {
		
		return new StringIndex(index);
	}
	
	public StringIndex plus(StringIndex adding) {
		return StringIndex.of(value + adding.value);
	}
	
	public StringIndex plus(int adding) {
		return StringIndex.of(value + adding);
	}
	
	public boolean isValid() {
		return value >=0;
	}

	public static StringIndex invalid() {
		return INVALID;
	}
	
	static final StringIndex INVALID = new StringIndex(-1);
}