package org.unlaxer.jaddress.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.jaddress.entity.standard.定義済みRange階層要素;
import org.unlaxer.jaddress.entity.zip.ZipBasedAddress;
import org.unlaxer.util.collection.TreeNode;
import org.unlaxer.util.collection.TreeNodeList;

import io.vavr.control.Either;

public class TownNameTokenizer implements AddressProcessor {

	@Override
	public ParsingState targetState() {
		return ParsingState.検索住所配列を町名を元に二分割する;
	}

	static final Predicate<AddressElement> match都道府県から町名まで = 
			addressElement->addressElement.id().equals(定義済みRange階層要素.都道府県から町名まで.id());
			
	static final Predicate<AddressElement> match町名より後 =
			addressElement->addressElement.id().equals(定義済みRange階層要素.町名より後.id());

	@Override
	public TargetStateAndElement process(ParsingTarget parsingTarget) {


		TreeNode<AddressElement> targetNode = targetNode(parsingTarget);

		Either<List<? super ZipBasedAddress>, TreeNodeList<AddressElement>> split = split(targetNode, parsingTarget);

		if (split.isRight()) {
			
			TreeNodeList<AddressElement> list = split.get();
			
			AddressElement 都道府県から町名まで = list
					.findAsContent(match都道府県から町名まで)
					.orElseThrow();
			
			targetNode
				.findWithContent(match都道府県から町名まで)
				.ifPresent(treeNode->treeNode.resetObject(都道府県から町名まで));
			
			TreeNode<AddressElement> 町名以降 = list
				.find(match町名より後)
				.orElseThrow();

			
			targetNode.addChild(町名以降);
			SingleOrRange階層要素 next階層要素 = 町名以降.get().singleOrRange階層要素();
			
			return new TargetStateAndElement(ParsingState.町名から丁目の階層種類をDBを用いて求める , next階層要素);
		}
		return new TargetStateAndElement(ParsingState.町名分割エラー , SingleOrRange階層要素.of(定義済みRange階層要素.全体));
	}

	private Either<List<? super ZipBasedAddress>, TreeNodeList<AddressElement>> split(
			TreeNode<AddressElement> targetNode,
			ParsingTarget parsingTarget) {

		AddressContext addressContext = parsingTarget.addressContext();
		
		List<? extends ZipBasedAddress> jyuusyoJps = parsingTarget.intermediateResult().zipBasedAddressesFromZip();

		List<? super ZipBasedAddress> faileds = new ArrayList<>();

		for (ZipBasedAddress zipBasedAddress : jyuusyoJps) {

			TreeNodeList<AddressElement> split = split(addressContext, targetNode, zipBasedAddress);
			if (split.isEmpty() || split.size() < 2) {
				faileds.add(zipBasedAddress);
			} else {
				return Either.right(split);
			}
		}
		return Either.left(faileds);
	}

	static TreeNodeList<AddressElement> split(
			AddressContext addressContext, 
			TreeNode<AddressElement> targetNode,
			ZipBasedAddress zipBasedAddress) {

		String townName = zipBasedAddress.townName();

		if (townName == null || "NULL".equals(townName)) {
			return TreeNodeList.empty();
		}

//			String blockName = jyuusyoJP.blockName;

		TreeNodeList<AddressElement> split = addressContext.split(
				targetNode, 
				new SeparatorWithKind(townName, SeparatorKind.domainSpecificSeparator),
				SplitStrategy.Tuple2_SeparatorJoinWithLeft,
				SingleOrRange階層要素.of(定義済みRange階層要素.都道府県から町名まで),
				SingleOrRange階層要素.of(定義済みRange階層要素.町名より後));
		return split;
	}
}