package org.unlaxer.jaddress.parser;

import java.io.Serializable;

public class TripletAddressToken implements Serializable{
	
	private static final long serialVersionUID = 3470438721519259530L;

	public final AddressToken original;

	private final AddressToken predecessor;
	private final AddressToken matched;
	private final AddressToken successor;
	
	public TripletAddressToken(
			AddressToken original,
			AddressToken predecessor, 
			AddressToken matched,
			AddressToken successor) {
		super();
		this.predecessor = predecessor;
		this.matched = matched;
		this.successor = successor;
		this.original = original;
	}
	
	public TripletAddressToken onlySuccessorOf() {
		
		return new TripletAddressToken(AddressToken.empty(),AddressToken.empty(), AddressToken.empty(), successor);
	}

	
	public static TripletAddressToken onlySuccessorOf(AddressToken successorOfAddressToken) {
		
		return new TripletAddressToken(
				successorOfAddressToken,
				AddressToken.empty(), 
				AddressToken.empty(), 
				successorOfAddressToken);
	}

	public TripletAddressToken(AddressToken  original ,  StringIndex matchIndex , int length , SeparatorKind leading , SeparatorKind tailing) {
		super();
		this.original = original;
		
		if(matchIndex.value == -1) {
			predecessor = AddressToken.empty();
			matched = AddressToken.empty();
			successor = AddressToken.empty();
			return;
		}
		if(matchIndex.value == 0) {
			matched = original.substring(
					matchIndex , 
					matchIndex.plus(length),
					original.separatorKindOfLeading(),
					leading
			).strip();
			predecessor = AddressToken.empty();
		}else {
			predecessor = original.substring(
					StringIndex.of(0),
					matchIndex,
					original.separatorKindOfLeading(),
					leading
			).strip();
			matched = original.substring(
					matchIndex , 
					matchIndex.plus(length),
					tailing,
					original.separatorKindOfTailing()
			).strip();
		}
		successor = matchIndex.plus(length).value < original.length() ?
			original.substring(
				matchIndex.plus(length) ,
				StringIndex.of(original.length()),
				original.separatorKindOfTailing(),
				tailing
			).strip():
			AddressToken.empty();
	}
	
	public TripletAddressToken(
			AddressToken  original ,  
			ListIndex fromInclusive , 
			ListIndex toExclusive , 
			SeparatorKind leading , 
			SeparatorKind tailing) {

		super();
		this.original = original;
		
		predecessor = 
				original.subList(ListIndex.of(0), fromInclusive , 
						original.separatorKindOfLeading() , leading);
		matched = 
				original.subList(fromInclusive, toExclusive ,
						leading , tailing);
		successor = 
				original.subList(toExclusive, ListIndex.of(original.stringAndCharacterKinds().size()) , 
						tailing , original.separatorKindOfTailing());
	}

	
	public AddressToken predecessor(){
		return predecessor;
	}
	
	public AddressToken matched(){
		return matched;
	}
	
	public AddressToken successor(){
		return successor;
	}
	
	public AddressToken joinPredecessorAndMatched() {
		return new AddressTokenImpl(
			predecessor.stringAndCharacterKinds()
				.join(matched.stringAndCharacterKinds()), 
			predecessor.separatorKindOfLeading(), 
			matched.separatorKindOfTailing()
		);
	}
	
//	public StringAndCharacterKinds predecessorAndMatched() {
//		return predecessor.join(matched);
//	}
//	
//	public StringAndCharacterKinds matchedAndSuccessor() {
//		return matched.join(successor);
//	}
	
	public static TripletAddressToken empty(AddressToken originalString) {
		
		return new TripletAddressToken(
				originalString, 
				StringIndex.of(-1) ,
				0 ,
				originalString.separatorKindOfLeading(),
				originalString.separatorKindOfTailing());
	}
	
	public boolean isMatched() {
		
		return matched().isPresent();
	}

	@Override
	public String toString() {
		return original.toString()+"=[" + predecessor.toString()  + "][" + matched.toString() +"][" + successor.toString() +"]";
	}
}