package org.unlaxer.jaddress.parser;

import java.util.List;
import java.util.stream.Stream;

import org.unlaxer.jaddress.entity.standard.郵便番号;
import org.unlaxer.jaddress.entity.zip.ZipBasedAddress;

public interface ZipBasedAddressDataAccessContext{
	
	//	郵便番号に対して２個以上の住所が引っかかる場合もある。
	//src/test/resources/multipleJyuusyoJPResults.txt を参照
	List<? extends ZipBasedAddress> selectZipBasedAddresssByZip(郵便番号 zip);
	
	Stream<? extends ZipBasedAddress> selectAllZipBasedAddress();
	
	String reloadZipBasedAddresses();
	
	
	
	/*
	都道府県別町域数リスト
	都道府県コード 都道府県名 町域数
	01 北海道 7,404
	02 青森県 1,974
	03 岩手県 1,570
	04 宮城県 2,213
	05 秋田県 1,635
	06 山形県 1,920
	07 福島県 3,219
	08 茨城県 2,820
	09 栃木県 1,811
	10 群馬県 1,481
	11 埼玉県 2,906
	12 千葉県 3,492
	13 東京都 1,716
	14 神奈川県 2,122
	15 新潟県 5,217
	16 富山県 2,646
	17 石川県 2,358
	18 福井県 2,097
	19 山梨県 935
	20 長野県 1,441
	21 岐阜県 3,255
	22 静岡県 2,814
	23 愛知県 6,696
	24 三重県 2,421
	25 滋賀県 1,819
	26 京都府 6,305
	27 大阪府 3,461
	28 兵庫県 5,118
	29 奈良県 1,902
	30 和歌山県 1,590
	31 鳥取県 1,381
	32 島根県 1,166
	33 岡山県 2,183
	34 広島県 2,006
	35 山口県 1,482
	36 徳島県 755
	37 香川県 674
	38 愛媛県 1,659
	39 高知県 1,589
	40 福岡県 3,255
	41 佐賀県 834
	42 長崎県 1,813
	43 熊本県 1,873
	44 大分県 1,598
	45 宮崎県 847
	46 鹿児島県 1,397
	47 沖縄県 795
	全国計 111,665
	Nippon Statistics Center 1 / 1 ページ
	*/
	
	//市町村数(町域を含まず) 1800弱
//	https://www.e-stat.go.jp/municipalities/number-of-municipalities
	
	/*
全国町・字ファイル及び番地データファイルの収録件数 （2019年10月号現在）
県コード	県名	全国町・字ファイル（廃止地名を含む件数）	全国町・字ファイル（廃止地名を含まない件数）	番地データファイル
	01	北海道	32723	28661	137
	02	青森	19526	14582	12
	03	岩手	26383	17266	12
	04	宮城	59291	35322	6
	05	秋田	45950	28881	2
	06	山形	16037	11831	12
	07	福島	101942	75414	6
	08	茨城	6254	4024	20
	09	栃木	3246	2403	10
	10	群馬	2452	1801	2
	11	埼玉	7671	5497	0
	12	千葉	7656	5968	10
	13	東京	8473	8085	8
	14	神奈川	5997	5123	2
	15	新潟	13663	7919	20
	16	富山	5918	4413	2
	17	石川	11715	10184	2
	18	福井	4400	2986	0
	19	山梨	1875	1232	11
	20	長野	6496	4830	22
	21	岐阜	8894	7244	6
	22	静岡	6564	3979	10
	23	愛知	87228	61527	12
	24	三重	4322	3228	0
	25	滋賀	3861	2539	4
	26	京都	42222	33978	8
	27	大阪	10849	9211	13
	28	兵庫	18536	14242	23
	29	奈良	3380	2913	6
	30	和歌山	2655	1976	6
	31	鳥取	3276	2184	0
	32	島根	11187	6802	2
	33	岡山	5230	3021	0
	34	広島	6083	4327	2
	35	山口	10229	6782	2
	36	徳島	15314	10245	2
	37	香川	1389	1034	2
	38	愛媛	4305	2987	0
	39	高知	2994	2063	2
	40	福岡	8635	6749	10
	41	佐賀	4077	2674	2
	42	長崎	3544	2223	2
	43	熊本	5318	3206	10
	44	大分	4515	3311	18
	45	宮崎	2227	2021	14
	46	鹿児島	2800	1876	42
	47	沖縄	1594	1289	0
	合計	668,896	480,053	4
	*/
}