package org.unlaxer.jaddress.parser;

import java.util.Set;
import java.util.SortedSet;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import org.unlaxer.jaddress.entity.standard.建物階層;
import org.unlaxer.util.collection.Comparators;

public class _BuildingHierarchyResolverResult implements 建物階層Holder , 建物名Holder{
	
	final Supplier<建物階層> _建物階層;
	final SortedSet<String> buildingNames;
	
	public _BuildingHierarchyResolverResult(Supplier<建物階層> _建物階層, Set<String> buildingNames) {
		super();
		this._建物階層 = _建物階層;
		this.buildingNames = new TreeSet<String>(Comparators.longerIsFirst);
		this.buildingNames.addAll(buildingNames);
	}
	
	public _BuildingHierarchyResolverResult(Supplier<建物階層> _建物階層) {
		super();
		this._建物階層 = _建物階層;
		this.buildingNames = new TreeSet<String>();
	}
	
	public String toString() {
		return new StringJoiner(",","{","}")
			.add("建物階層:'"+_建物階層.get().name()+ "'")
			.add("buildingNames:"+
					buildingNames.stream()
						.map(x->"'" + x + "'")
						.collect(Collectors.joining(",", "[", "]"))
			).toString();
	}
	
	@Override
	public 建物階層 建物階層() {
		if(_建物階層 == null) {
			return 建物階層.不明;
		}
		return _建物階層.get();
	}
	
	public SortedSet<String> buildingNames(){
		return buildingNames;
	}

	@Override
	public SortedSet<String> buidingNames() {
		return buildingNames;
	}
}