package org.unlaxer.jaddress.parser.picker;

import java.util.Optional;

import javax.annotation.Nullable;

import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.jaddress.parser.AddressElement;
import org.unlaxer.jaddress.parser.AddressElementFactory;
import org.unlaxer.jaddress.parser.AddressToken;

public class PickerResult{
	
	final SingleOrRange階層要素 _階層要素;
	final Optional<AddressToken> predecessor;
	final AddressToken value;
	final AddressToken suffix;
	final Optional<AddressToken> successor;
	
	public PickerResult(
			SingleOrRange階層要素 _階層要素,
			@Nullable AddressToken predecessor,
			AddressToken value,
			AddressToken suffix,
			@Nullable AddressToken successor) {
		super();
		this._階層要素 = _階層要素;
		this.predecessor = Optional.ofNullable(predecessor);
		this.value = value;
		this.suffix = suffix;
		this.successor = Optional.ofNullable(successor);
	}
	
	public SingleOrRange階層要素 SingleOrRange階層要素() {
		return _階層要素;
	}

	public Optional<AddressToken> predecessor() {
		return predecessor;
	}

	public AddressToken value() {
		return value;
	}

	public AddressToken suffix() {
		return suffix;
	}

	public Optional<AddressToken> successor() {
		return successor;
	}
	
	public boolean isPredecessorAndSuccessorEmpty() {
		return predecessor.isEmpty() && successor.isEmpty();
	}
	
	public AddressElement asAddressElement() {
		AddressElement addressElement = AddressElementFactory.of(value, _階層要素);
		addressElement.setSuffix(suffix.asString());
		return addressElement;
	}
}