package org.unlaxer.jaddress.parser.picker;

import java.util.ListIterator;
import java.util.Optional;
import java.util.function.Predicate;

import org.unlaxer.jaddress.parser.AddressToken;
import org.unlaxer.jaddress.parser.CharacterKind;
import org.unlaxer.jaddress.parser.ListIndex;
import org.unlaxer.jaddress.parser.SeparatorKind;
import org.unlaxer.jaddress.parser.StringAndCharacterKind;
import org.unlaxer.jaddress.parser.TripletAddressToken;

public abstract class ReverseScanner{
	
	static final Predicate<CharacterKind> skips = CharacterKind::isDelimitorSpace;

	public Optional<TripletAddressToken> scan(AddressToken addressToken  ,SeparatorKind separatorKind){
		
		ListIterator<StringAndCharacterKind> iterator = 
				addressToken.stringAndCharacterKinds().listIteratorFromLast();
		
		Predicate<CharacterKind> targetKindPredicate = targetKindPredicate();
		
		boolean skipSpace = skipSpace(iterator);
		
		int toIndexExclusive = iterator.previousIndex()+ 1;//(skipSpace ? 0 : 1);
		int fromIndex = iterator.previousIndex();
		
		boolean match = false;
		while(iterator.hasPrevious()) {
			
			StringAndCharacterKind previous = iterator.previous();
			if(targetKindPredicate.test(previous.characterKind())) {
				fromIndex = iterator.previousIndex();
				match = true;
			}else {
				break;
			}
		}
		return match ?
				Optional.of(
					new TripletAddressToken(
							addressToken, 
							ListIndex.of(fromIndex+1), //TODO ; +1 ?
							ListIndex.of(toIndexExclusive),
							separatorKind, separatorKind)
//					stringAndCharacterKinds.createTriplet(ListIndex.of(fromIndex+1), ListIndex.of(toIndexExclusive))
				):
				Optional.empty();
	}
	
	boolean skipSpace(ListIterator<StringAndCharacterKind> iterator) {
		
		if(iterator.hasPrevious()) {
			StringAndCharacterKind previous = iterator.previous();
			CharacterKind characterKind = previous.characterKind();
			if(skipKindPredicate().test(characterKind)) {
				return true;
			}else {
				iterator.next();
			}
		}
		return false;
	}
	
	public static boolean skip(
			ListIterator<StringAndCharacterKind> iterator , 
			Predicate<CharacterKind> predicate) {
		
		boolean skipped = false;
		
		while(iterator.hasPrevious()) {
			
			StringAndCharacterKind previous = iterator.previous();
			CharacterKind characterKind = previous.characterKind();
			
			if(predicate.test(characterKind)) {
				skipped = true;
			}else {
				iterator.next();
			}
		}
		return skipped;
	}
	
	public abstract Predicate<CharacterKind> targetKindPredicate();
	
	public Predicate<CharacterKind> skipKindPredicate(){
		return skips;
	}
}