package org.unlaxer.jaddress.parser.picker;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.Predicate;

import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.jaddress.parser.AddressToken;
import org.unlaxer.jaddress.parser.AddressTokenImpl;
import org.unlaxer.jaddress.parser.CharacterKind;
import org.unlaxer.jaddress.parser.SeparatorKind;
import org.unlaxer.jaddress.parser.StringAndCharacterKind;
import org.unlaxer.jaddress.parser.StringAndCharacterKinds;
import org.unlaxer.jaddress.parser.StringIndex;
import org.unlaxer.jaddress.parser.TripletAddressToken;

public interface ValueAndSuffixPicker {
	
	public SingleOrRange階層要素 階層要素();
	public List<String> suffix();
	public ReverseScanner scanner();
	
	public default Predicate<CharacterKind> delimitors() {
		
		Predicate<CharacterKind> predicate = CharacterKind::isDelimitor;
		
		return predicate
			.or(CharacterKind::isHiragana)
			.or(CharacterKind::isKatakana)
			.or(CharacterKind::isNormal);
	}
	
	public default Optional<PickerResult> pick(AddressToken source){
		return pick(source , suffix()  , 階層要素() , scanner());
	}
	
	default Optional<PickerResult> pick(AddressToken source , List<String> suffixies, SingleOrRange階層要素 _階層要素, ReverseScanner scanner){
		for (String suffix : suffixies) {
			
			Optional<PickerResult> pick = pick(source, suffix , _階層要素 , scanner);
			if(pick.isPresent()) {
				return pick;
			}
		}
		return Optional.empty();
	}
	
	default Optional<PickerResult> pick(AddressToken source, String suffix , SingleOrRange階層要素 _階層要素 , ReverseScanner scanner) {
		
		StringIndex indexOf = source.indexOf(suffix);
		
		if(indexOf.value == -1) {
			return Optional.empty();
		}
		TripletAddressToken triplet = new TripletAddressToken(
				source, 
				indexOf ,
				suffix.length() , 
				SeparatorKind.domainSpecificSeparator ,
				SeparatorKind.domainSpecificSeparator
		);
		
		AddressToken predecessorWithKind = triplet.predecessor();
		
		if(predecessorWithKind.isEmpty()) {
			return Optional.empty();
		}
		
		Optional<TripletAddressToken> scan = scanner.scan(predecessorWithKind , SeparatorKind.domainSpecificSeparator);
		
		Optional<PickerResult> map = 
				scan
					.filter(this::valid)
					.map(scanned -> 
					new PickerResult(
						_階層要素,
						scanned.predecessor(),
						scanned.matched() ,
						triplet.matched(),
//						scanned.successor()
						triplet.successor()
					)
				); 
		
		return map;
	}
	
	public boolean valid(TripletAddressToken scanned);
	
	public static StringAndCharacterKinds scan(
			ListIterator<StringAndCharacterKind> iterator , 
			Predicate<CharacterKind> predicate) {
		
		List<StringAndCharacterKind> matched = new ArrayList<StringAndCharacterKind>();
		
		while(iterator.hasPrevious()) {
			
			StringAndCharacterKind previous = iterator.previous();
			CharacterKind characterKind = previous.characterKind();
			
			if(predicate.test(characterKind)) {
				matched.add(0,previous);
			}else {
				iterator.next();
				break;
			}
		}
		return new StringAndCharacterKinds(matched);
	}
	
//	default Optional<PickerResult> pickWithoutSuffix(String string) {
//		return pickWithoutSuffix(new StringAndCharacterKinds(string));
//	}
	
	default Optional<PickerResult> pickWithoutSuffix(AddressToken addressToken) {
		
		var listIteratorFromLast = addressToken.stringAndCharacterKinds().listIteratorFromLast();
		
		Predicate<CharacterKind> targetKindPredicate = scanner().targetKindPredicate();
		
		StringAndCharacterKinds skipped = scan(listIteratorFromLast, targetKindPredicate.negate());
		
		StringAndCharacterKinds target = scan(listIteratorFromLast, targetKindPredicate);
		
		if(target.isPresent()) {
			
			StringAndCharacterKinds predecessor  = scan(listIteratorFromLast, checkKind->true);
			
			TripletAddressToken tripletAddressToken = new TripletAddressToken(
					addressToken , 
					new AddressTokenImpl(predecessor, SeparatorKind.domainSpecificSeparator, SeparatorKind.domainSpecificSeparator),
					new AddressTokenImpl(target, SeparatorKind.domainSpecificSeparator, SeparatorKind.domainSpecificSeparator),
					new AddressTokenImpl(skipped, SeparatorKind.domainSpecificSeparator, SeparatorKind.domainSpecificSeparator)
			);
			if(false == valid(tripletAddressToken)) {
				return Optional.empty();
			}
			
			return Optional.of(
				new PickerResult(
					階層要素(),
					new AddressTokenImpl(predecessor, addressToken.separatorKindOfLeading() , SeparatorKind.domainSpecificSeparator) ,
					new AddressTokenImpl(target , SeparatorKind.domainSpecificSeparator , SeparatorKind.domainSpecificSeparator) ,
					AddressToken.empty(),
					new AddressTokenImpl(skipped, SeparatorKind.domainSpecificSeparator , addressToken.separatorKindOfTailing())
				)
			);
		}else {
			return Optional.empty();
		}
	}

}