package org.unlaxer.jaddress.parser.picker;

import java.util.ArrayList;
import java.util.List;

import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.jaddress.entity.standard.定義済みRange階層要素;
import org.unlaxer.jaddress.entity.standard.階層要素;
import org.unlaxer.jaddress.parser.AddressContext;
import org.unlaxer.jaddress.parser.AddressElement;
import org.unlaxer.jaddress.parser.AddressToken;
import org.unlaxer.jaddress.parser.PickerParer;
import org.unlaxer.jaddress.parser.PickerResults;
import org.unlaxer.jaddress.parser.PickerResults.PredecessorOrSuccessor;
import org.unlaxer.util.collection.TreeNode;

import io.vavr.Tuple3;

public class 号室Parser implements PickerParer{

	static ValueAndSuffixPicker picker = new 号室Picker();
	
	@Override
	public 階層要素 output階層要素() {
		return 階層要素.建物Bottom1;
	}

	@Override
	public ValueAndSuffixPicker picker() {
		return picker;
	}
	
	@Override
	public void addChild(AddressContext addressContext, TreeNode<AddressElement> target, AddressElement child) {
		addressContext.addChild(0, target, child);
	}

	@Override
	public List<Tuple3<PredecessorOrSuccessor, SingleOrRange階層要素, AddressToken>> targetTokens(
			PickerResults pickerResults) {
		
		List<Tuple3<PredecessorOrSuccessor, SingleOrRange階層要素, AddressToken>> results = 
				new ArrayList<>();
		
		pickerResults.get(PredecessorOrSuccessor.successor)
			.forEach((_階層要素 , addressToken)->{
				PickerParer.setTokenWithSuccessor(SingleOrRange階層要素.of(定義済みRange階層要素.建物より後) , 
						results, _階層要素, addressToken
				);
				PickerParer.setTokenWithSuccessor(SingleOrRange階層要素.of(定義済みRange階層要素.建物以降) , 
						results, _階層要素, addressToken
				);
				PickerParer.setTokenWithSuccessor(SingleOrRange階層要素.of(階層要素.建物) , 
						results, _階層要素, addressToken
				);
				PickerParer.setTokenWithSuccessor(SingleOrRange階層要素.of(階層要素.建物Bottom3) , 
						results, _階層要素, addressToken
				);
				PickerParer.setTokenWithSuccessor(SingleOrRange階層要素.of(階層要素.建物Bottom2) , 
						results, _階層要素, addressToken
				);
			});
		
		return results;
	}

}