package org.unlaxer.jaddress.parser.picker;

import java.util.List;

import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.jaddress.entity.standard.階層要素;
import org.unlaxer.jaddress.parser.TripletAddressToken;

public class 様方Picker implements ValueAndSuffixPicker{

	@Override
	public SingleOrRange階層要素 階層要素() {
		return SingleOrRange階層要素.of(階層要素.方書き);
	}
	
	static ReverseScanner scanner = new 漢字ReverseScanner();
	
	@Override
	public List<String> suffix() {
		return List.of("様方");
	}

	@Override
	public ReverseScanner scanner() {
		return scanner;
	}
	
	@Override
	public boolean valid(TripletAddressToken scanned) {
		//あまり長いsuffixはNGとする。簡易的な実装
		return scanned.successor().asString().length() <6;
	}


}