package org.unlaxer.jaddress.parser.processor;

import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unlaxer.jaddress.entity.standard.定義済みRange階層要素;
import org.unlaxer.jaddress.entity.standard.階層要素;
import org.unlaxer.jaddress.parser.AddressContext;
import org.unlaxer.jaddress.parser.AddressElement;
import org.unlaxer.jaddress.parser.AddressElementFactory;
import org.unlaxer.jaddress.parser.AddressProcessor;
import org.unlaxer.jaddress.parser.BuildingHierarchyResolverResult;
import org.unlaxer.jaddress.parser.BuildingNameSplitter;
import org.unlaxer.jaddress.parser.IntermediateResult;
import org.unlaxer.jaddress.parser.NumberParser;
import org.unlaxer.jaddress.parser.ParsingState;
import org.unlaxer.jaddress.parser.ParsingTarget;
import org.unlaxer.jaddress.parser.TargetStateAndElement;
import org.unlaxer.jaddress.parser.TripletAddressToken;
import org.unlaxer.util.Singletons;
import org.unlaxer.util.collection.TreeNode;

public class BuildingTokenizer implements AddressProcessor {
	
	Logger logger = LoggerFactory.getLogger(getClass());

	@Override
	public ParsingState targetState() {
		return ParsingState.建物名の抜き出しをする;
	}

//	@Override
//	public 階層要素 target階層要素() {
//		return 階層要素.建物以降;
//	}
	
	static NumberParser numberParser = Singletons.get(NumberParser.class);
	
	@Override
	public TargetStateAndElement process(ParsingTarget parsingTarget) {

		AddressContext addressContext = parsingTarget.addressContext();
		IntermediateResult intermediateResult = parsingTarget.intermediateResult();
		
		BuildingHierarchyResolverResult buildingHierarchyResult = intermediateResult.buildingHierarchy();
//		建物階層 buildingHierarchy = intermediateResult.建物階層();
		
		TreeNode<AddressElement> targetNode = targetNode(parsingTarget);

		
		AddressElement addressElement = targetNode.get();
		
		logger.debug("target block address {}" , addressElement);
		
		Optional<TripletAddressToken> matchedWithBuilding = 
				BuildingNameSplitter.split(addressElement, buildingHierarchyResult);
		
		matchedWithBuilding.ifPresent(matched->{
			
			addressContext.addChild(
				targetNode ,
				
				AddressElementFactory.of(
					matched.joinPredecessorAndMatched(), 
					階層要素.建物
				)
			);
			addressContext.addChild(
				targetNode ,
				AddressElementFactory.of(
					matched.successor(), 
					定義済みRange階層要素.建物より後
				)
			);
		});
		
//		if(buildingHierarchy == 建物階層.建物無し ||
//			(buildingHierarchy == 建物階層.建物名のみ && matchedWithBuilding.isPresent())){
//			
//			return new TargetStateAndElement(
//					ParsingState.建物より後のTokenをmappingする ,
//					SingleOrRange階層要素.of(定義済みRange階層要素.全体));
//		}
		return new TargetStateAndElement(
			ParsingState.建物より後の分割をする ,parsingTarget.target階層要素()); 
	}
}