package org.unlaxer.jaddress.parser.processor;

import org.unlaxer.jaddress.entity.standard.定義済みRange階層要素;
import org.unlaxer.jaddress.parser.AddressContext;
import org.unlaxer.jaddress.parser.AddressProcessor;
import org.unlaxer.jaddress.parser.BuildingHierarchyResolver;
import org.unlaxer.jaddress.parser.BuildingHierarchyResolverResult;
import org.unlaxer.jaddress.parser.TargetStateAndElement;
import org.unlaxer.jaddress.parser.ParsingState;
import org.unlaxer.jaddress.parser.ParsingTarget;
import org.unlaxer.jaddress.parser.IntermediateResult;

public class HeuristicBuildingHierarchyResolver implements AddressProcessor{

	@Override
	public ParsingState targetState() {
		return ParsingState.都道府県から枝番までで建物階層と建物名をDBを用いて求める;
	}

//	@Override
//	public 階層要素 target階層要素() {
//		return 階層要素.都道府県以降から建物より前まで;
//	}
	
	@Override
	public TargetStateAndElement process(ParsingTarget parsingTarget) {
		
		AddressContext addressContext = parsingTarget.addressContext();
		IntermediateResult intermediateResult = parsingTarget.intermediateResult();
		BuildingHierarchyResolver resolver = parsingTarget.dataAccessContext().getBuildingHierarchyResolver();
		
		BuildingHierarchyResolverResult resolve = resolver.resolve(addressContext);
		
		intermediateResult.setBuildingHierarchyResolverResult(resolve);
		
		return new TargetStateAndElement(ParsingState.建物名の抜き出しをする, 定義済みRange階層要素.建物以降);
	}
}