package org.unlaxer.jaddress.parser.processor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.jaddress.entity.standard.定義済みRange階層要素;
import org.unlaxer.jaddress.entity.standard.階層要素;
import org.unlaxer.jaddress.parser.AddressContext;
import org.unlaxer.jaddress.parser.AddressElements;
import org.unlaxer.jaddress.parser.AddressProcessor;
import org.unlaxer.jaddress.parser.BuildingHierarchyResolverResult;
import org.unlaxer.jaddress.parser.IntermediateResult;
import org.unlaxer.jaddress.parser.ParsingState;
import org.unlaxer.jaddress.parser.ParsingTarget;
import org.unlaxer.jaddress.parser.PickerResults;
import org.unlaxer.jaddress.parser.TargetStateAndElement;

public class RemainsTokenMapper implements AddressProcessor{
	
	Logger logger = LoggerFactory.getLogger(getClass());
	
	@Override
	public ParsingState targetState() {
		return ParsingState.建物より後のTokenをmappingする;
	}


	@Override
	public TargetStateAndElement process(ParsingTarget parsingTarget) {
		
		AddressContext addressContext = parsingTarget.addressContext();
		
		IntermediateResult intermediateResult = parsingTarget.intermediateResult();
		
		PickerResults sources = addressContext.pickerResults();
		
		AddressElements addressElements = new AddressElements(addressContext);
		
		BuildingHierarchyResolverResult buildingHierarchy = intermediateResult.buildingHierarchy();

		//TODO @link to TestCase
		if(buildingHierarchy != null) {
			
//			建物階層 _建物階層 = buildingHierarchy.建物階層();
			
//			if(addressElements.notExists(階層要素.建物Bottom1) && _建物階層.isValid(階層要素.建物Bottom1)) {
			if(addressElements.notExists(階層要素.建物Bottom1)) {
				sources.pickerResult(SingleOrRange階層要素.of(階層要素.建物Bottom1))
					.ifPresent(pickerResult->{
						addressElements.add(pickerResult.asAddressElement());
				});
			}
		}
		
		parsingTarget.setAddressElements(addressElements);
		return new TargetStateAndElement(ParsingState.パース終了, 定義済みRange階層要素.全体);
	}
}