package org.unlaxer.jaddress.parser.processor;

import org.unlaxer.jaddress.parser.CharacterKinds;

public class TripletCharacterKinds{
	
	final CharacterKinds prefix;
	final CharacterKinds target;
	final CharacterKinds suffix;
	public TripletCharacterKinds(CharacterKinds prefix, CharacterKinds target, CharacterKinds suffix) {
		super();
		this.prefix = prefix;
		this.target = target;
		this.suffix = suffix;
	}
	public CharacterKinds prefix() {
		return prefix;
	}
	public CharacterKinds target() {
		return target;
	}
	public CharacterKinds suffix() {
		return suffix;
	}
	@Override
	public String toString() {
		return prefix.toString() + target.toString() + suffix.toString();
	}
	
	public TripletCharacterKinds add(TripletCharacterKinds adding) {
		
		
		return new TripletCharacterKinds(
			prefix.add(adding.prefix),
			target.add(adding.target),
			suffix.add(adding.suffix)
		);
	}
}