package org.unlaxer.jaddress.parser.processor;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.jaddress.entity.standard.定義済みRange階層要素;
import org.unlaxer.jaddress.entity.standard.郵便番号;
import org.unlaxer.jaddress.entity.zip.ZipBasedAddress;
import org.unlaxer.jaddress.parser.AddressContext;
import org.unlaxer.jaddress.parser.AddressElement;
import org.unlaxer.jaddress.parser.AddressProcessor;
import org.unlaxer.jaddress.parser.DataAccessContext;
import org.unlaxer.jaddress.parser.EmptyAddressElement;
import org.unlaxer.jaddress.parser.IntermediateResult;
import org.unlaxer.jaddress.parser.ParsingState;
import org.unlaxer.jaddress.parser.ParsingTarget;
import org.unlaxer.jaddress.parser.ResolverResult;
import org.unlaxer.jaddress.parser.ResolverResultKindOfBoolean;
import org.unlaxer.jaddress.parser.TargetStateAndElement;
import org.unlaxer.util.collection.TreeNode;

public class ZipToAddressResolver implements AddressProcessor{

	@Override
	public ParsingState targetState() {
		return ParsingState.ZIPから郵便番号情報取得;
	}

	@Override
	public TargetStateAndElement process(ParsingTarget parsingTarget) {
		
		AddressContext addressContext = parsingTarget.addressContext();
		DataAccessContext dataAccessContext = parsingTarget.dataAccessContext();
		郵便番号 zip = addressContext.zip();
		
		List<? extends ZipBasedAddress> zipBasedAddresss = 
				dataAccessContext.selectZipBasedAddresssByZip(zip);
		
		TreeNode<AddressElement> targetNode = targetNode(parsingTarget);
		
		if(zipBasedAddresss == null || zipBasedAddresss.isEmpty()) {
			return new TargetStateAndElement(
				ParsingState.郵便番号情報取得失敗エラー ,
				SingleOrRange階層要素.of(定義済みRange階層要素.全体));
			
		}else if(zipBasedAddresss.stream()
				.allMatch(address->
					StringUtils.isEmpty(address.townName() )&& 
					address.supplementaryTownNames().isEmpty())){
			
			boolean 町名無しでもOK = zipBasedAddresss.stream()
				.anyMatch(ZipBasedAddress::町名無し次に番地が来る);

			if(町名無しでもOK  ) {
				
				parsingTarget.addResolverResult(
						new ResolverResult(ResolverResultKindOfBoolean.郵便番号辞書町名無し));
				
			}else {
				
				return new TargetStateAndElement(
						ParsingState.郵便番号情報町名取得失敗エラー,
						SingleOrRange階層要素.of(定義済みRange階層要素.全体));
			}
			
		}
			
		parsingTarget.addResolverResult(
				new ResolverResult(ResolverResultKindOfBoolean.郵便番号辞書取得済み));
		
		IntermediateResult intermediateResult = parsingTarget.intermediateResult();
		intermediateResult.setZipBasedAddressesFromZip(zipBasedAddresss);
		
		addressContext.addChild(
			targetNode , 
			new EmptyAddressElement(SingleOrRange階層要素.of(定義済みRange階層要素.都道府県から町名まで))
		);
		return new TargetStateAndElement(
			ParsingState.都道府県から町名までを分割する , 
			SingleOrRange階層要素.of(定義済みRange階層要素.都道府県から町名まで));
	}
}