package org.unlaxer.jaddress.parser.processor;

import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unlaxer.jaddress.entity.standard.階層要素;
import org.unlaxer.jaddress.parser.AddressContext;
import org.unlaxer.jaddress.parser.AddressElement;
import org.unlaxer.jaddress.parser.AddressProcessor;
import org.unlaxer.jaddress.parser.TargetStateAndElement;
import org.unlaxer.jaddress.parser.ParsingState;
import org.unlaxer.jaddress.parser.ParsingTarget;
import org.unlaxer.jaddress.parser.PickerParer;
import org.unlaxer.jaddress.parser.PickerParer.AfterAction;
import org.unlaxer.jaddress.parser.PickerParer.Pick;
import org.unlaxer.jaddress.parser.PickerResults.PredecessorOrSuccessor;
import org.unlaxer.jaddress.parser.picker.PickerResult;
import org.unlaxer.jaddress.parser.picker.Unconditional建物Parser;
import org.unlaxer.jaddress.parser.picker.号室Parser;
import org.unlaxer.jaddress.parser.picker.棟Parser;
import org.unlaxer.jaddress.parser.picker.様方Parser;
import org.unlaxer.jaddress.parser.picker.階Parser;

public class 建物以降Parser implements AddressProcessor{
		
	Logger logger = LoggerFactory.getLogger(getClass());
	
	static final PickerParer 号室Parser = new 号室Parser();
	static final PickerParer 様方Parser = new 様方Parser();
	static final PickerParer 階Parser = new 階Parser();
	static final PickerParer 棟Parser = new 棟Parser();
	static final PickerParer unconditional建物Parser = new Unconditional建物Parser();
	@Override
	public ParsingState targetState() {
		return ParsingState.建物より後の分割をする;
	}


	@Override
	public TargetStateAndElement process(ParsingTarget parsingTarget) {
		
		AddressContext addressContext = parsingTarget.addressContext();
		
		
		AddressElement targetAddressElement = targetNode(parsingTarget).get();
		
		addressContext.pickerResults().add(
				targetAddressElement.singleOrRange階層要素(), 
				PredecessorOrSuccessor.successor, 
				targetAddressElement
		);
		
		Optional<PickerResult> 号室 = 号室Parser.parse(parsingTarget , Pick.withSuffix/*Pick.withoutSuffix*/, AfterAction.addResultToAddressContext);
		Optional<PickerResult> 階 =  階Parser.parse(parsingTarget  , Pick.withSuffix , AfterAction.addResultToAddressContext);
		Optional<PickerResult> 棟 = 棟Parser.parse(parsingTarget  , Pick.withSuffix , AfterAction.addResultToAddressContext);
		様方Parser.parse(parsingTarget , Pick.withSuffix , AfterAction.addResultToAddressContext);
		
		if(号室.isEmpty()) {
			号室 = 号室Parser.parse(parsingTarget, Pick.withoutSuffix , AfterAction.addResultToAddressContext);
		}
		if(階.isEmpty()) {
			階 = 階Parser.parse(parsingTarget, Pick.withoutSuffix , AfterAction.addResultToAddressContext);
		}
		if(棟.isEmpty()) {
			棟 = 棟Parser.parse(parsingTarget  , Pick.withoutSuffix , AfterAction.addResultToAddressContext);
		}
		
		unconditional建物Parser.parse(parsingTarget , Pick.withoutSuffix , AfterAction.addResultToAddressContext);
		
		return new TargetStateAndElement(ParsingState.建物より後のTokenをmappingする, 階層要素.不明/* 階層要素.その他*/);
	}
}