package org.unlaxer.jaddress.tokenizer;

import java.lang.Character.UnicodeBlock;

public class TokenWithCharacterKind {
	public TokenWithCharacterKind(String word, CharacterType characterType) {
		super();
		this.word = word;
		this.characterType = characterType;
	}

	public TokenWithCharacterKind(String word, UnicodeBlock unicodeBlock) {
		super();
		this.word = word;
		this.unicodeBlock = unicodeBlock;
	}

	String word;
	CharacterType characterType;
	UnicodeBlock unicodeBlock;

	public String format() {
		return String.format("\tword[%s], type[%s]", word, characterType != null ? characterType : unicodeBlock);
	}
}
