package org.unlaxer.jaddress.util.checker;

import java.util.List;

public class CheckData {

		String id;
		String zip;
		String kenName;
		String cityName;
		String townName;
		boolean city;
		boolean town;
		
		
		public CheckData() {
			
		}

		public CheckData(String line, List<String> target) {
			String[] buf = line.split(",");
			this.id = buf[0];
			this.zip = buf[1];
			this.kenName = buf[2];
			this.cityName = buf[3];
			this.townName = buf[4];
			this.city = target.parallelStream().anyMatch(s -> cityName.contains(s));
			this.town = target.parallelStream().anyMatch(s -> townName.contains(s));
		}

		public boolean hasValue() {
			return city || town;
		}


		
		public String getId() {
			return id;
		}

		public void setId(String id) {
			this.id = id;
		}

		public String getZip() {
			return zip;
		}

		public void setZip(String zip) {
			this.zip = zip;
		}

		public String getKenName() {
			return kenName;
		}

		public void setKenName(String kenName) {
			this.kenName = kenName;
		}

		public String getCityName() {
			return cityName;
		}

		public void setCityName(String cityName) {
			this.cityName = cityName;
		}

		public String getTownName() {
			return townName;
		}

		public void setTownName(String townName) {
			this.townName = townName;
		}

		public boolean isCity() {
			return city;
		}

		public void setCity(boolean city) {
			this.city = city;
		}

		public boolean isTown() {
			return town;
		}

		public void setTown(boolean town) {
			this.town = town;
		}

	}
