package org.unlaxer.jaddress.util.kuromoji;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

import com.atilika.kuromoji.ipadic.Token;

public class Tokens{
		
	public final List<Token> tokens;
	
	public String  joined;

	public Tokens(List<Token> tokens) {
		super();
		this.tokens = tokens;
		joined = tokens.stream()
			.map(Token::getSurface)
			.collect(Collectors.joining());
	}

	public Tokens(Token... tokens) {
		this(List.of(tokens));
	}
	
	public List<Tokens> grouping(BiPredicate<Token, Token> groupingPredicate){
		
		List<Tokens> results = new ArrayList<Tokens>();
		
		List<Token> currentList = new ArrayList<Token>();
		
		Iterator<Token> iterator = tokens.iterator();
		
		Token previous = iterator.next();
		
		currentList.add(previous);
		
		while (iterator.hasNext()) {
			
			Token next = iterator.next();
			if(groupingPredicate.test(previous, next)) {
				currentList.add(next);
			}else {
				results.add(new Tokens(new ArrayList<>(currentList)));
				currentList.clear();
				currentList.add(next);
			}
			
			previous = next;
		}
		if(false == currentList.isEmpty()) {
			results.add(new Tokens(new ArrayList<>(currentList)));
			currentList.clear();
		}
		return results;
	}

	@Override
	public String toString() {
		
		return joined;
	}
}