package org.unlaxer.jaddress.util.normalize;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

import org.unlaxer.jaddress.UserHomeContext;
import org.unlaxer.jaddress.parser.MultiCharacterFastMapper;

import io.vavr.Lazy;

public class WordReplacer implements UnaryOperator<String>{
	
	public static final Lazy<WordReplacer> SINGLETON = Lazy.of(WordReplacer::new);
	
	MultiCharacterFastMapper multiCharacterFastMapper ;
	
	boolean replaceJyoyo = false;

	public WordReplacer() {
		super();
		try(InputStream resourceAsStream = resourceAsStream();
				BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream, Charset.forName("utf8")))){
			
			Set<String> 常用漢字Set = 常用漢字.get();
			
			Predicate<? super String[]> predicate = replaceJyoyo ? 
					array->false == 常用漢字Set.contains( array[0]):
					array->true ; 
					
			Map<String, String> replacedByKey = reader.lines()
				.map(x->x.split("=>"))
				.filter(predicate)
				.collect(Collectors.toMap(array->array[0], array->array[1]));
			
			multiCharacterFastMapper = new MultiCharacterFastMapper(replacedByKey);
			
		} catch (IOException e) {
			throw new UncheckedIOException(e);
		}
	}

	@Override
	public String apply(String target) {
		return multiCharacterFastMapper.replace(target);
	}
	
	public static String replace(String target) {
		return SINGLETON.get().apply(target);
	}
	
	static InputStream resourceAsStream() throws IOException {
		Path pathWithFolderAndFile = UserHomeContext.getPathWithFolderAndFile("vacant", "word-mappings.txt");
		return Files.exists(pathWithFolderAndFile)?
				Files.newInputStream(pathWithFolderAndFile):
				WordReplacer.class.getResourceAsStream("/word-mappings.txt");
	}
}
