package org.unlaxer.util.properties;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;

import org.apache.commons.lang3.StringUtils;

public enum SystemProperties {
	
	AwtToolkit("awt.toolkit"),
	FileEncoding("file.encoding"),
	FileEncodingPkg("file.encoding.pkg"),
	FileSeparator("file.separator"),
	JavaAwtGraphicsenv("java.awt.graphicsenv"),
	JavaAwtPrinterjob("java.awt.printerjob"),
	JavaClassPath("java.class.path"),
	JavaClassVersion("java.class.version"),
	JavaEndorsedDirs("java.endorsed.dirs"),
	JavaExtDirs("java.ext.dirs"),
	JavaHome("java.home"),
	JavaIoTmpdir("java.io.tmpdir"),
	JavaLibraryPath("java.library.path"),
	JavaRuntimeName("java.runtime.name"),
	JavaRuntimeVersion("java.runtime.version"),
	JavaSpecificationName("java.specification.name"),
	JavaSpecificationVendor("java.specification.vendor"),
	JavaSpecificationVersion("java.specification.version"),
	JavaVendor("java.vendor"),
	JavaVendorUrl("java.vendor.url"),
	JavaVendorUrlBug("java.vendor.url.bug"),
	JavaVersion("java.version"),
	JavaVmInfo("java.vm.info"),
	JavaVmName("java.vm.name"),
	JavaVmSpecificationName("java.vm.specification.name"),
	JavaVmSpecificationVendor("java.vm.specification.vendor"),
	JavaVmSpecificationVersion("java.vm.specification.version"),
	JavaVmVendor("java.vm.vendor"),
	JavaVmVersion("java.vm.version"),
	LineSeparator("line.separator"),
	OsArch("os.arch"),
	OsName("os.name"),
	OsVersion("os.version"),
	PathSeparator("path.separator"),
	SunArchDataModel("sun.arch.data.model"),
	SunBootClassPath("sun.boot.class.path"),
	SunBootLibraryPath("sun.boot.library.path"),
	SunCpuEndian("sun.cpu.endian"),
	SunCpuIsalist("sun.cpu.isalist"),
	SunDesktop("sun.desktop"),
	SunIoUnicodeEncoding("sun.io.unicode.encoding"),
	SunJavaCommand("sun.java.command"),
	SunJavaLauncher("sun.java.launcher"),
	SunJnuEncoding("sun.jnu.encoding"),
	SunManagementCompiler("sun.management.compiler"),
	SunOsPatchLevel("sun.os.patch.level"),
	UserCountry("user.country"),
	UserDir("user.dir"),
	UserHome("user.home"),
	UserLanguage("user.language"),
	UserName("user.name"),
	UserScript("user.script"),
	UserTimezone("user.timezone"),
	UserVariant("user.variant"),
	Target("fraud.alert.property.target"),
	
	HostName(()->{
		String getenv;
		getenv = System.getenv("HOSTNAME");
		if(StringUtils.isNotBlank(getenv)){
			return Optional.of(getenv);
		}
		getenv = System.getenv("COMPUTERNAME");
		if(StringUtils.isNotBlank(getenv)){
			return Optional.of(getenv);
		}
		try {
			return Optional.of(InetAddress.getLocalHost().getHostName());
		} catch (UnknownHostException e) {
		}
		return Optional.empty();
	}),
	;
	public String key;
	Supplier<Optional<String>> valueSupplier;
	
	static Map<SystemProperties,String> valueByKey = new HashMap<>();

	private SystemProperties(String key) {
		this.key = key;
	}
	
	private SystemProperties(Supplier<Optional<String>> valueSupplier) {
		this.valueSupplier = valueSupplier;
	}

	public Optional<String> getProperty(Properties properties){
		String string = valueByKey.get(this);
		if(string != null){
			return Optional.of(string);
		}
		
		if(key == null){
			return valueSupplier.get();
		}
		return Optional.ofNullable(properties.getProperty(key));
	}
	
	public Optional<String> getProperty(){
		return getProperty(System.getProperties());
	}
	
	public static Optional<String> getProperty(String name,Properties properties){
		try{
			SystemProperties systemProperties = SystemProperties.valueOf(name);
			return systemProperties.getProperty(properties);
		}catch(Exception e){
			return Optional.ofNullable(System.getenv(name));
		}
		
	}
	
	public void set(String value) {
		System.setProperty(key, value);
	}
	
	public static Optional<String> getProperty(String name){
		
		return getProperty(name, System.getProperties());
	}
	
	public static void override(SystemProperties systemProperties , String value){
		valueByKey.put(systemProperties, value);
	}
	
	public void override(String value){
		valueByKey.put(this, value);
	}

}
