/*
 * Decompiled with CFR 0.152.
 */
package org.unlaxer.tinyexpression.evaluator.bigdecimal;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.unlaxer.Token;
import org.unlaxer.tinyexpression.CalculationContext;
import org.unlaxer.tinyexpression.TokenBaseOperator;
import org.unlaxer.tinyexpression.evaluator.bigdecimal.CalculatorOperator;

public abstract class AbstractMultiParameterFunctionOperator
implements TokenBaseOperator<CalculationContext, BigDecimal> {
    public BigDecimal evaluate(CalculationContext context, Token functionOperator) {
        List<BigDecimal> operands = AbstractMultiParameterFunctionOperator.getParameters(functionOperator).stream().map(token -> CalculatorOperator.SINGLETON.evaluate(context, (Token)token)).collect(Collectors.toList());
        return this.apply(context, operands);
    }

    abstract BigDecimal apply(CalculationContext var1, List<BigDecimal> var2);

    static List<Token> getParameters(Token parenthesesedOperator) {
        Token token = (Token)parenthesesedOperator.filteredChildren.get(0);
        return Arrays.asList((Token)token.filteredChildren.get(2), (Token)token.filteredChildren.get(4));
    }

    double angle(CalculationContext calculationContext, double angle) {
        if (calculationContext.angle() == CalculationContext.Angle.RADIAN) {
            return angle;
        }
        return Math.toRadians(angle);
    }

    public abstract int parameterCount();
}

