/*
 * Decompiled with CFR 0.152.
 */
package org.unlaxer.tinyexpression.evaluator.bigdecimal;

import java.util.Iterator;
import java.util.List;
import org.unlaxer.Token;
import org.unlaxer.tinyexpression.CalculationContext;
import org.unlaxer.tinyexpression.TokenBaseOperator;
import org.unlaxer.tinyexpression.evaluator.bigdecimal.BooleanExpressionOperator;

public class BooleanClauseOperator
implements TokenBaseOperator<CalculationContext, Boolean> {
    public static BooleanClauseOperator SINGLETON = new BooleanClauseOperator();

    public Boolean evaluate(CalculationContext context, Token token) {
        List originalTokens = token.filteredChildren;
        Iterator iterator = originalTokens.iterator();
        BooleanExpressionOperator booleanOperator = BooleanExpressionOperator.SINGLETON;
        boolean value = booleanOperator.evaluate(context, (Token)iterator.next());
        while (iterator.hasNext()) {
            Token operator = (Token)iterator.next();
            String operatorString = (String)operator.tokenString.orElseThrow(IllegalArgumentException::new);
            boolean nextValue = booleanOperator.evaluate(context, (Token)iterator.next());
            if ("==".equals(operatorString)) {
                value = value == nextValue;
                continue;
            }
            if ("!=".equals(operatorString)) {
                value = value != nextValue;
                continue;
            }
            if ("&".equals(operatorString)) {
                value = value && nextValue;
                continue;
            }
            if ("|".equals(operatorString)) {
                value = value || nextValue;
                continue;
            }
            if ("^".equals(operatorString)) {
                value ^= nextValue;
                continue;
            }
            throw new IllegalArgumentException();
        }
        return value;
    }
}

