/*
 * Decompiled with CFR 0.152.
 */
package org.unlaxer.tinyexpression.evaluator.bigdecimal;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import org.unlaxer.Token;
import org.unlaxer.parser.ascii.DivisionParser;
import org.unlaxer.parser.ascii.MinusParser;
import org.unlaxer.parser.ascii.PlusParser;
import org.unlaxer.parser.combinator.ChoiceInterface;
import org.unlaxer.parser.elementary.MultipleParser;
import org.unlaxer.parser.elementary.NumberParser;
import org.unlaxer.parser.elementary.ParenthesesParser;
import org.unlaxer.tinyexpression.CalculationContext;
import org.unlaxer.tinyexpression.TokenBaseOperator;
import org.unlaxer.tinyexpression.evaluator.bigdecimal.CosOperator;
import org.unlaxer.tinyexpression.evaluator.bigdecimal.FactorOfStringOperator;
import org.unlaxer.tinyexpression.evaluator.bigdecimal.IfExpressionOperator;
import org.unlaxer.tinyexpression.evaluator.bigdecimal.MatchExpressionOperator;
import org.unlaxer.tinyexpression.evaluator.bigdecimal.MaxOperator;
import org.unlaxer.tinyexpression.evaluator.bigdecimal.MinOperator;
import org.unlaxer.tinyexpression.evaluator.bigdecimal.NumberOperator;
import org.unlaxer.tinyexpression.evaluator.bigdecimal.RandomOperator;
import org.unlaxer.tinyexpression.evaluator.bigdecimal.SinOperator;
import org.unlaxer.tinyexpression.evaluator.bigdecimal.SquareRootOperator;
import org.unlaxer.tinyexpression.evaluator.bigdecimal.TanOperator;
import org.unlaxer.tinyexpression.evaluator.bigdecimal.VariableOperator;
import org.unlaxer.tinyexpression.parser.ExpressionParser;
import org.unlaxer.tinyexpression.parser.FactorOfStringParser;
import org.unlaxer.tinyexpression.parser.FactorParser;
import org.unlaxer.tinyexpression.parser.IfExpressionParser;
import org.unlaxer.tinyexpression.parser.MatchExpressionParser;
import org.unlaxer.tinyexpression.parser.TermParser;
import org.unlaxer.tinyexpression.parser.VariableParser;
import org.unlaxer.tinyexpression.parser.function.CosParser;
import org.unlaxer.tinyexpression.parser.function.MaxParser;
import org.unlaxer.tinyexpression.parser.function.MinParser;
import org.unlaxer.tinyexpression.parser.function.RandomParser;
import org.unlaxer.tinyexpression.parser.function.SinParser;
import org.unlaxer.tinyexpression.parser.function.SquareRootParser;
import org.unlaxer.tinyexpression.parser.function.TanParser;

public class CalculatorOperator
implements TokenBaseOperator<CalculationContext, BigDecimal> {
    public static final CalculatorOperator SINGLETON = new CalculatorOperator();

    public BigDecimal evaluate(CalculationContext calculationContext, Token token) {
        if (token.parser instanceof ExpressionParser) {
            List originalTokens = token.filteredChildren;
            Iterator iterator = originalTokens.iterator();
            BigDecimal value = this.evaluate(calculationContext, (Token)iterator.next());
            while (iterator.hasNext()) {
                Token operator = (Token)iterator.next();
                BigDecimal operand = this.evaluate(calculationContext, (Token)iterator.next());
                if (operator.parser instanceof PlusParser) {
                    value = value.add(operand);
                    continue;
                }
                if (!(operator.parser instanceof MinusParser)) continue;
                value = value.subtract(operand);
            }
            return value;
        }
        if (token.parser instanceof TermParser) {
            List originalTokens = token.filteredChildren;
            Iterator iterator = originalTokens.iterator();
            BigDecimal value = this.evaluate(calculationContext, (Token)iterator.next());
            while (iterator.hasNext()) {
                Token operator = (Token)iterator.next();
                BigDecimal operand = this.evaluate(calculationContext, (Token)iterator.next());
                if (operator.parser instanceof MultipleParser) {
                    value = value.multiply(operand);
                    continue;
                }
                if (!(operator.parser instanceof DivisionParser)) continue;
                value = value.divide(operand, calculationContext.scale(), calculationContext.roundingMode());
            }
            return value;
        }
        if (token.parser instanceof FactorParser) {
            Token operator = ChoiceInterface.choiced((Token)token);
            if (operator.parser instanceof NumberParser) {
                return NumberOperator.SINGLETON.evaluate(calculationContext, operator);
            }
            if (operator.parser instanceof VariableParser) {
                return (BigDecimal)VariableOperator.SINGLETON.evaluate(calculationContext, operator);
            }
            if (operator.parser instanceof IfExpressionParser) {
                return IfExpressionOperator.SINGLETON.evaluate(calculationContext, operator);
            }
            if (operator.parser instanceof MatchExpressionParser) {
                return MatchExpressionOperator.SINGLETON.evaluate(calculationContext, operator);
            }
            if (operator.parser instanceof ParenthesesParser) {
                return this.evaluate(calculationContext, ParenthesesParser.getParenthesesed((Token)operator));
            }
            if (operator.parser instanceof SinParser) {
                return SinOperator.SINGLETON.evaluate(calculationContext, operator);
            }
            if (operator.parser instanceof CosParser) {
                return CosOperator.SINGLETON.evaluate(calculationContext, operator);
            }
            if (operator.parser instanceof TanParser) {
                return TanOperator.SINGLETON.evaluate(calculationContext, operator);
            }
            if (operator.parser instanceof SquareRootParser) {
                return SquareRootOperator.SINGLETON.evaluate(calculationContext, operator);
            }
            if (operator.parser instanceof MinParser) {
                return MinOperator.SINGLETON.evaluate(calculationContext, token);
            }
            if (operator.parser instanceof MaxParser) {
                return MaxOperator.SINGLETON.evaluate(calculationContext, token);
            }
            if (operator.parser instanceof RandomParser) {
                return RandomOperator.SINGLETON.evaluate(calculationContext, token);
            }
            if (operator.parser instanceof FactorOfStringParser) {
                return FactorOfStringOperator.SINGLETON.evaluate(calculationContext, operator);
            }
        }
        throw new IllegalArgumentException();
    }
}

