/*
 * Decompiled with CFR 0.152.
 */
package org.unlaxer.tinyexpression.evaluator.bigdecimal;

import java.math.BigDecimal;
import org.unlaxer.Token;
import org.unlaxer.tinyexpression.CalculationContext;
import org.unlaxer.tinyexpression.TokenBaseOperator;
import org.unlaxer.tinyexpression.evaluator.bigdecimal.IndexOfMethodOperator;
import org.unlaxer.tinyexpression.evaluator.bigdecimal.StringOperator;

public class StringIndexOfOperator
implements TokenBaseOperator<CalculationContext, BigDecimal> {
    public static final StringIndexOfOperator SINGLETON = new StringIndexOfOperator();

    public BigDecimal evaluate(CalculationContext context, Token token) {
        Token baseStringToken = (Token)token.filteredChildren.get(0);
        Token indexOfToken = (Token)token.filteredChildren.get(1);
        String base = StringOperator.SINGLETON.evaluate(context, baseStringToken);
        String indexOf = IndexOfMethodOperator.SINGLETON.evaluate(context, indexOfToken);
        if (base == null || base.isEmpty() || indexOf == null || indexOf.isEmpty()) {
            return new BigDecimal(-1);
        }
        return new BigDecimal(base.indexOf(indexOf));
    }
}

