/*
 * Decompiled with CFR 0.152.
 */
package org.unlaxer.tinyexpression.evaluator.bigdecimal;

import java.util.Iterator;
import java.util.Optional;
import org.unlaxer.Token;
import org.unlaxer.parser.Parser;
import org.unlaxer.parser.ascii.PlusParser;
import org.unlaxer.parser.combinator.ChoiceInterface;
import org.unlaxer.parser.elementary.ParenthesesParser;
import org.unlaxer.parser.elementary.QuotedParser;
import org.unlaxer.tinyexpression.CalculationContext;
import org.unlaxer.tinyexpression.TokenBaseOperator;
import org.unlaxer.tinyexpression.evaluator.bigdecimal.VariableStringOperator;
import org.unlaxer.tinyexpression.parser.StringExpressionParser;
import org.unlaxer.tinyexpression.parser.StringFactorParser;
import org.unlaxer.tinyexpression.parser.StringLiteralParser;
import org.unlaxer.tinyexpression.parser.StringTermParser;
import org.unlaxer.tinyexpression.parser.ToLowerCaseParser;
import org.unlaxer.tinyexpression.parser.ToUpperCaseParser;
import org.unlaxer.tinyexpression.parser.TrimParser;
import org.unlaxer.tinyexpression.parser.VariableParser;
import org.unlaxer.util.Slicer;

public class StringOperator
implements TokenBaseOperator<CalculationContext, String> {
    public static StringOperator SINGLETON = new StringOperator();

    public String evaluate(CalculationContext context, Token token) {
        Parser parser = token.parser;
        if (parser instanceof StringExpressionParser) {
            Iterator iterator = token.filteredChildren.iterator();
            StringBuilder builder = new StringBuilder();
            Token termToken = (Token)iterator.next();
            String evaluate = this.evaluate(context, termToken);
            builder.append(evaluate);
            while (iterator.hasNext()) {
                Token operator = (Token)iterator.next();
                Token operand = (Token)iterator.next();
                Parser currentParser = operator.getParser();
                if (!(currentParser instanceof PlusParser)) continue;
                builder.append(this.evaluate(context, operand));
            }
            return builder.toString();
        }
        if (parser instanceof StringTermParser) {
            Token stringFactorToken = (Token)token.filteredChildren.get(0);
            String evaluate = this.evaluate(context, stringFactorToken);
            int size = token.filteredChildren.size();
            if (size > 1) {
                for (int i = 1; i < size; ++i) {
                    Token slicerToken = (Token)token.filteredChildren.get(i);
                    Optional<String> specifier = slicerToken.getToken().map(wrapped -> wrapped.substring(1, wrapped.length() - 1));
                    String target = evaluate;
                    evaluate = specifier.map(splicerSpecifier -> new Slicer(target).pythonian(splicerSpecifier).get()).orElse(evaluate);
                }
            }
            return evaluate;
        }
        if (parser instanceof StringFactorParser) {
            Token choiceToken = ChoiceInterface.choiced((Token)token);
            return this.evaluate(context, choiceToken);
        }
        if (parser instanceof StringLiteralParser) {
            Token literalChoiceToken = ChoiceInterface.choiced((Token)token);
            String contents = QuotedParser.contents((Token)literalChoiceToken);
            return contents == null ? "" : contents;
        }
        if (parser instanceof VariableParser) {
            return (String)VariableStringOperator.SINGLETON.evaluate(context, token);
        }
        if (parser instanceof ParenthesesParser) {
            Token parenthesesed = ParenthesesParser.getParenthesesed((Token)token);
            String evaluate = this.evaluate(context, parenthesesed);
            return evaluate == null ? "" : evaluate;
        }
        if (parser instanceof TrimParser) {
            Token parenthesesed = TrimParser.getInnerParserParsed((Token)token);
            String evaluate = this.evaluate(context, parenthesesed);
            return evaluate == null ? "" : evaluate.trim();
        }
        if (parser instanceof ToUpperCaseParser) {
            Token parenthesesed = ToUpperCaseParser.getInnerParserParsed((Token)token);
            String evaluate = this.evaluate(context, parenthesesed);
            return evaluate == null ? "" : evaluate.toUpperCase();
        }
        if (parser instanceof ToLowerCaseParser) {
            Token parenthesesed = ToLowerCaseParser.getInnerParserParsed((Token)token);
            String evaluate = this.evaluate(context, parenthesesed);
            return evaluate == null ? "" : evaluate.toLowerCase();
        }
        throw new IllegalArgumentException();
    }
}

