/*
 * Decompiled with CFR 0.152.
 */
package com.daredayo.util;

import com.daredayo.util.collection.FactoryBoundCache;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;

public class NameSpecifier {
    SpecifierKind specifierKind;
    public Optional<String> stringName;
    public Optional<Enum<?>> enumName;
    int hashCode;
    static FactoryBoundCache<String, NameSpecifier> specifierByString = new FactoryBoundCache<String, NameSpecifier>(NameSpecifier::new);
    static FactoryBoundCache<Enum<?>, NameSpecifier> specifierByEnum = new FactoryBoundCache<Enum, NameSpecifier>(NameSpecifier::new);

    public NameSpecifier() {
    }

    public NameSpecifier(String stringName) {
        this.stringName = Optional.of(stringName);
        this.enumName = Optional.empty();
        this.hashCode = this.toString().hashCode();
        this.specifierKind = SpecifierKind.stringType;
    }

    public NameSpecifier(Enum<?> enumName) {
        this.enumName = Optional.of(enumName);
        this.stringName = Optional.empty();
        this.hashCode = this.toString().hashCode();
        this.specifierKind = SpecifierKind.enumType;
    }

    public boolean equals(Object other) {
        if (other instanceof NameSpecifier && this.stringName.isPresent()) {
            return ((NameSpecifier)other).toString().equals(this.toString());
        }
        if (other instanceof NameSpecifier && this.enumName.isPresent()) {
            return ((NameSpecifier)other).equals(this.enumName);
        }
        if (other instanceof Enum && this.stringName.isPresent()) {
            return ((Enum)other).name().equals(this.toString());
        }
        if (other instanceof Enum && this.enumName.isPresent()) {
            return (Enum)other == this.enumName.get();
        }
        if (other instanceof String) {
            return ((String)other).equals(this.toString());
        }
        return false;
    }

    public String toString() {
        return this.stringName.isPresent() ? this.stringName.get() : this.enumName.get().name();
    }

    public static NameSpecifier of(String name) {
        return specifierByString.get(name);
    }

    public static NameSpecifier of(Enum<?> name) {
        return specifierByEnum.get(name);
    }

    public static NameSpecifier of(Class<?> clazz) {
        return specifierByString.get(clazz.getName());
    }

    public static NameSpecifier classBaseOf(Object object) {
        return specifierByString.get(object.getClass().getName());
    }

    public static Stream<NameSpecifier> streamOf(Enum<?> ... enums) {
        return Arrays.asList(enums).stream().map(NameSpecifier::of);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static enum SpecifierKind {
        stringType,
        enumType,
        classType;

    }
}

