/*
 * Decompiled with CFR 0.152.
 */
package com.daredayo.util.args;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;

public class CommandLineUtil {
    public static Properties getProperties(String[] args) {
        StringBuilder builder = new StringBuilder();
        for (String command : args) {
            builder.append(CommandLineUtil.unicodeEscape(command));
            builder.append("\n");
        }
        Properties properties = System.getProperties();
        try {
            properties.load(new ByteArrayInputStream(builder.toString().getBytes("ISO-8859-1")));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }

    public static Properties getProperties(String commandLine) {
        return CommandLineUtil.getProperties(commandLine, "\\s*,\\s*");
    }

    static Properties getProperties(String commandLine, String sepRegex) {
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(commandLine.replaceAll(sepRegex, "\n").getBytes()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }

    static String[] splitArgs(String joinedStrings, String sepRegex, boolean trim) {
        String[] result = joinedStrings.split(sepRegex);
        if (trim) {
            int i = 0;
            for (String word : result) {
                result[i++] = word.trim();
            }
        }
        return result;
    }

    static String unicodeEscape(String value) {
        if (value == null) {
            return "";
        }
        char[] charValue = value.toCharArray();
        StringBuilder builder = new StringBuilder();
        for (char ch : charValue) {
            if (!(ch == '_' || ch >= '0' && '9' >= ch || ch >= 'a' && 'z' >= ch || ch >= 'A' && 'Z' >= ch || ch == '=')) {
                String unicodeCh = Integer.toHexString(ch);
                builder.append("\\u");
                for (int i = 0; i < 4 - unicodeCh.length(); ++i) {
                    builder.append("0");
                }
                builder.append(unicodeCh);
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }
}

