/*
 * Decompiled with CFR 0.152.
 */
package com.daredayo.util.collection;

import com.daredayo.util.collection.LongPeriod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class ContinuousLongPeriod
implements Supplier<Optional<LongPeriod>> {
    final List<Long> periods;
    final Supplier<Long> supplier;
    int index;
    int last;
    Long lastValue;

    public ContinuousLongPeriod(long ... periods) {
        this.supplier = null;
        this.periods = new ArrayList<Long>();
        for (long period : periods) {
            this.periods.add(period);
        }
        this.index = 0;
        this.last = periods.length - 1;
    }

    public ContinuousLongPeriod(Supplier<Long> supplier) {
        this.periods = null;
        this.supplier = supplier;
    }

    public ContinuousLongPeriod() {
        this.periods = new ArrayList<Long>();
        this.supplier = null;
        this.last = -1;
    }

    public void add(Long period) {
        this.periods.add(period);
        ++this.last;
    }

    @Override
    public Optional<LongPeriod> get() {
        if (this.supplier != null) {
            if (this.lastValue == null) {
                this.lastValue = this.supplier.get();
            }
            long current = this.supplier.get();
            LongPeriod longPeriod = new LongPeriod(this.lastValue, current);
            this.lastValue = current;
            return Optional.of(longPeriod);
        }
        if (this.index == this.last) {
            return Optional.empty();
        }
        return Optional.of(new LongPeriod(this.periods.get(this.index), this.periods.get(++this.index)));
    }

    protected List<LongPeriod> getList() {
        Object current;
        this.index = 0;
        ArrayList<LongPeriod> results = new ArrayList<LongPeriod>();
        while (((Optional)(current = this.get())).isPresent()) {
            ((Optional)current).ifPresent(results::add);
        }
        return results;
    }

    public Stream<LongPeriod> stream() {
        return this.getList().stream();
    }

    public Optional<LongPeriod> getOverall() {
        if (this.supplier != null) {
            throw new IllegalStateException("this method not support with constructed as Supplier instance");
        }
        if (this.periods.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new LongPeriod(this.periods.get(0), this.periods.get(this.periods.size() - 1)));
    }
}

