/*
 * Decompiled with CFR 0.152.
 */
package com.daredayo.util.collection;

public class StatisticsFloat {
    public float max;
    public float min;
    public float average;
    public double variance;
    public float count;
    private float sum;
    private float sumOverFlow;
    private float varianceSum;
    private float varianceSumOVerFlow;

    public void clear() {
        this.max = 0.0f;
        this.min = Float.MAX_VALUE;
        this.average = 0.0f;
        this.sum = 0.0f;
        this.count = 0.0f;
    }

    public StatisticsFloat() {
        this.clear();
    }

    public synchronized void add(float adding) {
        this.count += 1.0f;
        this.max = this.max < adding ? adding : this.max;
        float f = this.min = this.min > adding ? adding : this.min;
        if (StatisticsFloat.isOverFlow(this.sum, adding)) {
            this.sum += adding - Float.MAX_VALUE;
            this.sumOverFlow += 1.0f;
        } else {
            this.sum += adding;
        }
        this.average = this.sum / this.count + (float)(3.4028234663852886E38 * (double)this.sumOverFlow / (double)this.count);
        float f2 = adding - this.average;
        if (StatisticsFloat.isOverFlow(this.varianceSum, f2)) {
            this.varianceSum += f2 - Float.MAX_VALUE;
            this.varianceSumOVerFlow += 1.0f;
        } else {
            this.varianceSum += f2;
        }
        this.variance = (double)this.varianceSum / (double)this.count + 3.4028234663852886E38 * (double)this.varianceSumOVerFlow / (double)this.count;
    }

    static final boolean isOverFlow(float a, float b) {
        float old;
        return (a += b) < (old = a);
    }
}

