/*
 * Decompiled with CFR 0.152.
 */
package com.daredayo.util.io;

import com.daredayo.util.SnapShot;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class SnapShotReader
extends Reader
implements SnapShot<Character> {
    Reader reader;
    List<Character> snapshot = new ArrayList<Character>();
    boolean doSnapShot = false;

    public SnapShotReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public int read() throws IOException {
        int read = this.reader.read();
        if (this.doSnapShot && read != -1) {
            this.snapshot.add(Character.valueOf((char)read));
        }
        return read;
    }

    public String toString() {
        return this.reader.toString();
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Reader)this.reader);
        this.reader = null;
    }

    @Override
    public void start() {
        this.snapshot.clear();
        this.doSnapShot = true;
    }

    @Override
    public List<Character> stop() {
        this.doSnapShot = false;
        return this.snapshot;
    }

    @Override
    public List<Character> getSnapShot() {
        return this.snapshot;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int read = this.reader.read(cbuf, off, len);
        if (this.doSnapShot) {
            for (int i = 0; i < read; ++i) {
                this.snapshot.add(Character.valueOf(cbuf[i + off]));
            }
        }
        return read;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        int read = this.reader.read(target);
        if (this.doSnapShot) {
            for (int i = 0; i < read; ++i) {
                this.snapshot.add(Character.valueOf(target.charAt(i)));
            }
        }
        return read;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public boolean isClosed() {
        return this.reader == null;
    }
}

