/*
 * Decompiled with CFR 0.152.
 */
package com.daredayo.util.reflect;

import com.daredayo.util.reflect.FieldInfo;
import com.daredayo.util.reflect.MemberInfo;
import com.daredayo.util.reflect.MethodInfo;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MemberInfoContext {
    final List<MemberInfo> memberInfos = new ArrayList<MemberInfo>();
    final MemberInfo.MemberInfoType type;
    static Comparator<? super MemberInfo> comparator = (o1, o2) -> {
        Order annotation1 = o1.getAnnotation(Order.class);
        Order annotation2 = o2.getAnnotation(Order.class);
        if (annotation1 == null && annotation2 == null) {
            return 0;
        }
        if (annotation1 != null && annotation2 != null) {
            return annotation1.value() - annotation2.value();
        }
        if (annotation1 != null) {
            return -1;
        }
        return 1;
    };

    public MemberInfoContext(Class<?> clazz, MemberInfo.MemberInfoType menberInfoType) {
        Field[] fields = clazz.getFields();
        Method[] methods = clazz.getMethods();
        this.type = menberInfoType;
        switch (menberInfoType) {
            case Method: {
                for (Method method : methods) {
                    MethodInfo methodInfo;
                    NotScan notScan = method.getAnnotation(NotScan.class);
                    if (notScan != null || (methodInfo = new MethodInfo(method)).getName().length() == 0) continue;
                    this.memberInfos.add(methodInfo);
                }
                break;
            }
            case Field: {
                for (Field field : fields) {
                    NotScan notScan = field.getAnnotation(NotScan.class);
                    if (notScan != null) continue;
                    this.memberInfos.add(new FieldInfo(field));
                }
                break;
            }
        }
        Collections.sort(this.memberInfos, comparator);
    }

    public List<MemberInfo> getMemberInfos() {
        return this.memberInfos;
    }

    @Target(value={ElementType.FIELD, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Order {
        public int value();
    }

    @Target(value={ElementType.FIELD, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NotScan {
    }
}

