/*
 * Decompiled with CFR 0.152.
 */
package com.daredayo.util.reflect;

import com.daredayo.util.reflect.MemberInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodInfo
implements MemberInfo {
    private Method method;
    private String name;

    public MethodInfo(Method method) {
        this.method = method;
        this.name = MethodInfo.getMemberName(method.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.method.getReturnType();
    }

    @Override
    public Object get(Object object) {
        try {
            return this.method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getMemberName(String word) {
        String replaced;
        String string = word.startsWith("is") ? word.substring(2) : (replaced = word.startsWith("get") ? word.substring(3) : "");
        if (replaced.length() == 0) {
            return replaced;
        }
        return replaced.substring(0, 1).toLowerCase().concat(replaced.substring(1));
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.method.getAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.method.isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.method.getAnnotation(annotationClass);
    }
}

