/*
 * Decompiled with CFR 0.152.
 */
package org.longhorn.beanstalk.springintegration.config;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.PropertyConfigurator;
import org.longhorn.beanstalk.springintegration.config.S3ResourceException;
import org.longhorn.beanstalk.springintegration.config.S3ResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.web.util.Log4jWebConfigurer;

public class Log4jS3ConfigListener
implements ServletContextListener {
    private static final String CONFIG_LOCATION_PARAM = "log4jS3ConfigLocation";
    private boolean fallback = true;

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        String location = servletContext.getInitParameter(CONFIG_LOCATION_PARAM);
        if (location != null) {
            try {
                this.fallback = false;
                this.loadPropertiesFromS3(location);
            }
            catch (Exception e) {
                this.fallback = true;
                servletContext.log("failed to load log4j properties from s3", (Throwable)e);
            }
        }
        if (this.fallback) {
            Log4jWebConfigurer.initLogging((ServletContext)event.getServletContext());
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.fallback) {
            Log4jWebConfigurer.shutdownLogging((ServletContext)event.getServletContext());
        }
    }

    private void loadPropertiesFromS3(String location) {
        S3ResourceLoader s3ResourceLoader = new S3ResourceLoader();
        String resolvedLocation = this.parseStringValue(location);
        Resource resource = s3ResourceLoader.getResource(resolvedLocation);
        Properties properties = new Properties();
        try {
            properties.load(resource.getInputStream());
        }
        catch (IOException e) {
            throw new S3ResourceException("could not load log4j properties from " + resolvedLocation, e);
        }
        PropertyConfigurator.configure((Properties)properties);
    }

    private String parseStringValue(String strVal) {
        PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("${", "}", ":", false);
        SimpleSystemPropertyPlaceholderResolver resolver = new SimpleSystemPropertyPlaceholderResolver();
        return helper.replacePlaceholders(strVal, (PropertyPlaceholderHelper.PlaceholderResolver)resolver);
    }

    private class SimpleSystemPropertyPlaceholderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private SimpleSystemPropertyPlaceholderResolver() {
        }

        public String resolvePlaceholder(String placeholderName) {
            String value = System.getProperty(placeholderName);
            if (value == null) {
                throw new S3ResourceException("could not resolve " + placeholderName);
            }
            return value;
        }
    }
}

