/*
 * Decompiled with CFR 0.152.
 */
package org.longhorn.beanstalk.springintegration.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import org.longhorn.beanstalk.springintegration.config.S3ResourceLoader;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.Resource;

public class S3PropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private S3ResourceLoader resourceLoader;
    private String[] s3Locations = new String[0];
    private Resource[] conventionalResources = new Resource[0];

    public S3PropertyPlaceholderConfigurer() {
        this.resourceLoader = new S3ResourceLoader();
    }

    public void setLocations(Resource[] locations) {
        this.conventionalResources = locations;
    }

    public void setS3Locations(String[] s3Locations) {
        this.s3Locations = new String[s3Locations.length];
        for (int i = 0; i < s3Locations.length; ++i) {
            this.s3Locations[i] = this.parseStringValue(s3Locations[i], new Properties(), new HashSet());
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.injectS3Resources();
        super.postProcessBeanFactory(beanFactory);
    }

    private void injectS3Resources() {
        int total = this.conventionalResources.length + this.s3Locations.length;
        if (total > 0) {
            ArrayList<Resource> allResources = new ArrayList<Resource>();
            for (Resource resource : this.conventionalResources) {
                allResources.add(resource);
            }
            for (String string : this.s3Locations) {
                allResources.add(this.resourceLoader.getResource(string));
            }
            super.setLocations(allResources.toArray(new Resource[0]));
        }
    }
}

