/*
 * Decompiled with CFR 0.152.
 */
package com.usergrid.count;

import com.usergrid.count.BatchSubmitter;
import com.usergrid.count.Batcher;
import com.usergrid.count.CounterProcessingUnavailableException;
import com.usergrid.count.common.Count;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractBatcher
implements Batcher {
    protected BatchSubmitter batchSubmitter;
    private Batch batch;
    private final ReentrantLock submitLock = new ReentrantLock();
    private final AtomicLong opCount = new AtomicLong();
    private final Timer addTimer = Metrics.newTimer(AbstractBatcher.class, (String)"add_invocation", (TimeUnit)TimeUnit.MICROSECONDS, (TimeUnit)TimeUnit.SECONDS);
    private final Counter invocationCounter = Metrics.newCounter(AbstractBatcher.class, (String)"batch_add_invocations");
    private final Counter existingCounterHit = Metrics.newCounter(AbstractBatcher.class, (String)"counter_existed");

    public AbstractBatcher(int queueSize) {
        this.batch = new Batch();
    }

    @Override
    public void setBatchSubmitter(BatchSubmitter batchSubmitter) {
        this.batchSubmitter = batchSubmitter;
    }

    @Override
    public long getOpCount() {
        return this.opCount.get();
    }

    protected abstract boolean shouldSubmit(Batch var1);

    protected abstract void submit(Batch var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Count count) throws CounterProcessingUnavailableException {
        this.invocationCounter.inc();
        TimerContext context = this.addTimer.time();
        this.batch.add(count);
        if (this.shouldSubmit(this.batch) && this.submitLock.tryLock()) {
            try {
                this.submit(this.copyAndClear(this.batch));
            }
            finally {
                this.submitLock.unlock();
            }
        }
        context.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Batch copyAndClear(Batch original) {
        Batch copy;
        Batch batch = original;
        synchronized (batch) {
            copy = new Batch(original);
            original.clear();
        }
        return copy;
    }

    class Batch {
        private final Map<String, Count> counts;
        private final AtomicInteger localCallCounter = new AtomicInteger();

        Batch() {
            this.counts = new HashMap<String, Count>();
        }

        Batch(Batch batch) {
            this.localCallCounter.set(batch.localCallCounter.get());
            this.counts = new HashMap<String, Count>(batch.counts);
        }

        void clear() {
            this.counts.clear();
            this.localCallCounter.set(0);
        }

        void add(Count count) {
            AbstractBatcher.this.opCount.incrementAndGet();
            this.localCallCounter.incrementAndGet();
            Count found = this.counts.get(count.getCounterName());
            if (found != null) {
                AbstractBatcher.this.existingCounterHit.inc();
                this.counts.put(found.getCounterName(), found.apply(count));
            } else {
                this.counts.put(count.getCounterName(), count);
            }
        }

        public int getPayloadSize() {
            return this.counts.size();
        }

        public Collection<Count> getCounts() {
            return this.counts.values();
        }

        public int getLocalCallCount() {
            return this.localCallCounter.get();
        }
    }
}

