/*
 * Decompiled with CFR 0.152.
 */
package com.usergrid.count;

import com.usergrid.count.AbstractBatcher;
import com.usergrid.count.BatchSubmitter;
import com.usergrid.count.CassandraCounterStore;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraSubmitter
implements BatchSubmitter {
    private final Logger log = LoggerFactory.getLogger(CassandraSubmitter.class);
    private final int threadCount = 3;
    private final CassandraCounterStore cassandraCounterStore;
    private final ExecutorService executor = Executors.newFixedThreadPool(3);
    private final Timer addTimer = Metrics.newTimer(CassandraSubmitter.class, (String)"submit_invocation", (TimeUnit)TimeUnit.MICROSECONDS, (TimeUnit)TimeUnit.SECONDS);

    public CassandraSubmitter(CassandraCounterStore cassandraCounterStore) {
        this.cassandraCounterStore = cassandraCounterStore;
    }

    public Future submit(final AbstractBatcher.Batch batch) {
        return this.executor.submit(new Callable<Object>(){
            final TimerContext timer;
            {
                this.timer = CassandraSubmitter.this.addTimer.time();
            }

            @Override
            public Object call() throws Exception {
                CassandraSubmitter.this.cassandraCounterStore.save(batch.getCounts());
                this.timer.stop();
                return true;
            }
        });
    }

    @Override
    public void shutdown() {
        this.log.warn("Shutting down CassandraSubmitter");
        this.executor.shutdown();
    }
}

