/*
 * Decompiled with CFR 0.152.
 */
package com.usergrid.count;

import com.usergrid.count.AbstractBatcher;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledBatcher
extends AbstractBatcher {
    private static final Logger logger = LoggerFactory.getLogger(ScheduledBatcher.class);
    private int batchInterval;
    private long currentMillis;
    private AtomicLong batchSubmissionCount = new AtomicLong();

    public ScheduledBatcher(int queueSize, int batchInterval) {
        super(queueSize);
        this.batchInterval = batchInterval;
        this.currentMillis = System.currentTimeMillis();
    }

    @Override
    protected boolean shouldSubmit(AbstractBatcher.Batch batch) {
        long now = System.currentTimeMillis();
        return now > (long)(1000 * this.batchInterval) + this.currentMillis;
    }

    @Override
    protected void submit(AbstractBatcher.Batch batch) {
        this.currentMillis = System.currentTimeMillis();
        logger.info("Submitting batch counter payload. Resetting now to: {}", (Object)this.currentMillis);
        this.batchSubmitter.submit(batch);
        this.batchSubmissionCount.incrementAndGet();
    }

    @Override
    public long getBatchSubmissionCount() {
        return this.batchSubmissionCount.get();
    }
}

