/*
 * Decompiled with CFR 0.152.
 */
package com.usergrid.count;

import com.usergrid.count.AbstractBatcher;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBatcher
extends AbstractBatcher {
    private Logger log = LoggerFactory.getLogger(SimpleBatcher.class);
    private int batchSize = 500;
    private AtomicLong batchSubmissionCount = new AtomicLong();
    private boolean blockingSubmit = false;

    public SimpleBatcher(int queueSize) {
        super(queueSize);
    }

    @Override
    protected boolean shouldSubmit(AbstractBatcher.Batch batch) {
        if (this.batchSize == 0) {
            return true;
        }
        int localCallCount = batch.getLocalCallCount();
        return localCallCount > 0 && localCallCount % this.batchSize == 0;
    }

    @Override
    protected void submit(AbstractBatcher.Batch batch) {
        this.log.debug("submit triggered...");
        Future<?> f = this.batchSubmitter.submit(batch);
        if (this.blockingSubmit) {
            try {
                f.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        this.batchSubmissionCount.incrementAndGet();
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public long getBatchSubmissionCount() {
        return this.batchSubmissionCount.get();
    }

    public void setBlockingSubmit(boolean blockingSubmit) {
        this.blockingSubmit = blockingSubmit;
    }
}

