/*
 * Decompiled with CFR 0.152.
 */
package com.usergrid.count;

import com.usergrid.count.AbstractBatcher;
import com.usergrid.count.BatchSubmitter;
import com.usergrid.count.common.Count;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4JBatchSubmitter
implements BatchSubmitter {
    private Logger log = LoggerFactory.getLogger(Slf4JBatchSubmitter.class);
    private int threadCount = 3;
    private ExecutorService executor = Executors.newFixedThreadPool(this.threadCount);
    private final Timer addTimer = Metrics.newTimer(Slf4JBatchSubmitter.class, (String)"submit_invocation", (TimeUnit)TimeUnit.MICROSECONDS, (TimeUnit)TimeUnit.SECONDS);

    public Future submit(final AbstractBatcher.Batch batch) {
        return this.executor.submit(new Callable<Object>(){
            final TimerContext timer;
            {
                this.timer = Slf4JBatchSubmitter.this.addTimer.time();
            }

            @Override
            public Object call() throws Exception {
                for (Count c : batch.getCounts()) {
                    Slf4JBatchSubmitter.this.log.info("found count {}", (Object)c);
                }
                this.timer.stop();
                return true;
            }
        });
    }

    @Override
    public void shutdown() {
        this.log.warn("Shutdown Slf4jBatchSubmitter");
        this.executor.shutdown();
    }
}

