/*
 * Decompiled with CFR 0.152.
 */
package org.usergrid.websocket;

import java.util.Date;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class SimpleMessageProducer {
    private static final Logger logger = LoggerFactory.getLogger(SimpleMessageProducer.class);
    @Autowired
    protected JmsTemplate jmsTemplate;
    protected int numberOfMessages = 100;

    public void sendMessages() throws JMSException {
        int i = 0;
        while (i < this.numberOfMessages) {
            final StringBuilder payload = new StringBuilder();
            payload.append("Message [").append(i).append("] sent at: ").append(new Date());
            final int j = i++;
            this.jmsTemplate.send(new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    TextMessage message = session.createTextMessage(payload.toString());
                    message.setIntProperty("messageCount", j);
                    logger.info("Sending message number [" + j + "]");
                    return message;
                }
            });
        }
    }
}

