/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.maven.plugin;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.utplsql.api.DBHelper;
import org.utplsql.api.FileMapperOptions;
import org.utplsql.api.JavaApiVersionInfo;
import org.utplsql.api.KeyValuePair;
import org.utplsql.api.TestRunner;
import org.utplsql.api.Version;
import org.utplsql.api.exception.SomeTestsFailedException;
import org.utplsql.api.reporter.CoreReporters;
import org.utplsql.api.reporter.Reporter;
import org.utplsql.api.reporter.ReporterFactory;
import org.utplsql.maven.plugin.CustomTypeMapping;
import org.utplsql.maven.plugin.helper.PluginDefault;
import org.utplsql.maven.plugin.helper.SQLScannerHelper;
import org.utplsql.maven.plugin.model.ReporterParameter;
import org.utplsql.maven.plugin.reporter.ReporterWriter;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST)
public class UtPLSQLMojo
extends AbstractMojo {
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="dbUrl")
    protected String url;
    @Parameter(property="dbUser")
    protected String user;
    @Parameter(property="dbPass")
    protected String password;
    @Parameter
    protected String includeObject;
    @Parameter
    protected String excludeObject;
    @Parameter(defaultValue="false")
    protected boolean skipCompatibilityCheck;
    @Parameter
    protected List<ReporterParameter> reporters = new ArrayList<ReporterParameter>();
    @Parameter
    protected List<String> paths = new ArrayList<String>();
    @Parameter
    protected List<Resource> sources = new ArrayList<Resource>();
    @Parameter
    private String sourcesOwner;
    @Parameter
    private String sourcesRegexExpression;
    @Parameter
    private Integer sourcesOwnerSubexpression;
    @Parameter
    private Integer sourcesNameSubexpression;
    @Parameter
    private Integer sourcesTypeSubexpression;
    @Parameter
    private List<CustomTypeMapping> sourcesCustomTypeMapping;
    @Parameter
    protected List<Resource> tests = new ArrayList<Resource>();
    @Parameter
    private String testsOwner;
    @Parameter
    private String testsRegexExpression;
    @Parameter
    private Integer testsOwnerSubexpression;
    @Parameter
    private Integer testsNameSubexpression;
    @Parameter
    private Integer testsTypeSubexpression;
    @Parameter
    private List<CustomTypeMapping> testsCustomTypeMapping;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    protected String targetDir;
    @Parameter(defaultValue="${maven.test.failure.ignore}")
    protected boolean ignoreFailure;
    private boolean colorConsole = MessageUtils.isColorEnabled();
    private ReporterWriter reporterWriter;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Java Api Version = " + JavaApiVersionInfo.getVersion()));
        this.loadConfFromEnvironment();
        Connection connection = null;
        try {
            FileMapperOptions sourceMappingOptions = this.buildSourcesOptions();
            FileMapperOptions testMappingOptions = this.buildTestsOptions();
            connection = DriverManager.getConnection(this.url, this.user, this.password);
            Version utlVersion = DBHelper.getDatabaseFrameworkVersion((Connection)connection);
            this.getLog().info((CharSequence)("utPLSQL Version = " + utlVersion));
            List<Reporter> reporterList = this.initReporters(connection, utlVersion, ReporterFactory.createEmpty());
            this.logParameters(sourceMappingOptions, testMappingOptions, reporterList);
            TestRunner runner = new TestRunner().addPathList(this.paths).addReporterList(reporterList).sourceMappingOptions(sourceMappingOptions).testMappingOptions(testMappingOptions).skipCompatibilityCheck(this.skipCompatibilityCheck).colorConsole(this.colorConsole).failOnErrors(!this.ignoreFailure);
            if (StringUtils.isNotBlank((CharSequence)this.excludeObject)) {
                runner.excludeObject(this.excludeObject);
            }
            if (StringUtils.isNotBlank((CharSequence)this.includeObject)) {
                runner.includeObject(this.includeObject);
            }
            runner.run(connection);
        }
        catch (SomeTestsFailedException e) {
            try {
                this.getLog().error((Throwable)e);
                throw new MojoExecutionException(e.getMessage());
                catch (SQLException e2) {
                    this.getLog().error((Throwable)e2);
                    throw new MojoExecutionException(e2.getMessage(), (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (null == connection) throw throwable;
                    this.reporterWriter.writeReporters(connection);
                    throw throwable;
                }
                catch (Exception e3) {
                    this.getLog().error((CharSequence)e3.getMessage(), (Throwable)e3);
                }
                throw throwable;
            }
        }
        try {
            if (null == connection) return;
            this.reporterWriter.writeReporters(connection);
            return;
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            return;
        }
    }

    private void loadConfFromEnvironment() {
        if (StringUtils.isEmpty((CharSequence)this.url)) {
            this.url = System.getProperty("dbUrl");
        }
        if (StringUtils.isEmpty((CharSequence)this.user)) {
            this.user = System.getProperty("dbUser");
        }
        if (StringUtils.isEmpty((CharSequence)this.password)) {
            this.password = System.getProperty("dbPass");
        }
    }

    private FileMapperOptions buildSourcesOptions() throws MojoExecutionException {
        try {
            if (this.sources.isEmpty()) {
                File defaultSourceDirectory = new File(this.project.getBasedir(), "src/main/plsql");
                if (defaultSourceDirectory.exists()) {
                    this.sources.add(PluginDefault.buildDefaultSource());
                } else {
                    return new FileMapperOptions(new ArrayList());
                }
            }
            List<String> scripts = SQLScannerHelper.findSQLs(this.project.getBasedir(), this.sources, "src/main/plsql", "**/*.*");
            FileMapperOptions fileMapperOptions = new FileMapperOptions(scripts);
            if (StringUtils.isNotEmpty((CharSequence)this.sourcesOwner)) {
                fileMapperOptions.setObjectOwner(this.sourcesOwner);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.sourcesRegexExpression)) {
                fileMapperOptions.setRegexPattern(this.sourcesRegexExpression);
            }
            if (this.sourcesOwnerSubexpression != null) {
                fileMapperOptions.setOwnerSubExpression(this.sourcesOwnerSubexpression);
            }
            if (this.sourcesNameSubexpression != null) {
                fileMapperOptions.setNameSubExpression(this.sourcesNameSubexpression);
            }
            if (this.sourcesTypeSubexpression != null) {
                fileMapperOptions.setTypeSubExpression(this.sourcesTypeSubexpression);
            }
            if (this.sourcesCustomTypeMapping != null && !this.sourcesCustomTypeMapping.isEmpty()) {
                fileMapperOptions.setTypeMappings(new ArrayList());
                for (CustomTypeMapping typeMapping : this.sourcesCustomTypeMapping) {
                    fileMapperOptions.getTypeMappings().add(new KeyValuePair(typeMapping.getCustomMapping(), typeMapping.getType()));
                }
            }
            return fileMapperOptions;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Invalid <SOURCES> in your pom.xml", e);
        }
    }

    private FileMapperOptions buildTestsOptions() throws MojoExecutionException {
        try {
            if (this.tests.isEmpty()) {
                File defaultTestDirectory = new File(this.project.getBasedir(), "src/test/plsql");
                if (defaultTestDirectory.exists()) {
                    this.tests.add(PluginDefault.buildDefaultTest());
                } else {
                    return new FileMapperOptions(new ArrayList());
                }
            }
            List<String> scripts = SQLScannerHelper.findSQLs(this.project.getBasedir(), this.tests, "src/test/plsql", "**/*.pkg");
            FileMapperOptions fileMapperOptions = new FileMapperOptions(scripts);
            if (StringUtils.isNotEmpty((CharSequence)this.testsOwner)) {
                fileMapperOptions.setObjectOwner(this.testsOwner);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.testsRegexExpression)) {
                fileMapperOptions.setRegexPattern(this.testsRegexExpression);
            }
            if (this.testsOwnerSubexpression != null) {
                fileMapperOptions.setOwnerSubExpression(this.testsOwnerSubexpression);
            }
            if (this.testsNameSubexpression != null) {
                fileMapperOptions.setNameSubExpression(this.testsNameSubexpression);
            }
            if (this.testsTypeSubexpression != null) {
                fileMapperOptions.setTypeSubExpression(this.testsTypeSubexpression);
            }
            if (this.testsCustomTypeMapping != null && !this.testsCustomTypeMapping.isEmpty()) {
                fileMapperOptions.setTypeMappings(new ArrayList());
                for (CustomTypeMapping typeMapping : this.testsCustomTypeMapping) {
                    fileMapperOptions.getTypeMappings().add(new KeyValuePair(typeMapping.getCustomMapping(), typeMapping.getType()));
                }
            }
            return fileMapperOptions;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Invalid <TESTS> in your pom.xml: " + e.getMessage());
        }
    }

    private List<Reporter> initReporters(Connection connection, Version utlVersion, ReporterFactory reporterFactory) throws SQLException {
        ArrayList<Reporter> reporterList = new ArrayList<Reporter>();
        this.reporterWriter = new ReporterWriter(this.targetDir, utlVersion);
        if (this.reporters.isEmpty()) {
            ReporterParameter reporterParameter = new ReporterParameter();
            reporterParameter.setConsoleOutput(true);
            reporterParameter.setName(CoreReporters.UT_DOCUMENTATION_REPORTER.name());
            this.reporters.add(reporterParameter);
        }
        for (ReporterParameter reporterParameter : this.reporters) {
            Reporter reporter = reporterFactory.createReporter(reporterParameter.getName());
            reporter.init(connection);
            reporterList.add(reporter);
            if (!reporterParameter.isFileOutput() && null == reporterParameter.getConsoleOutput()) {
                reporterParameter.setConsoleOutput(true);
            }
            if (!StringUtils.isNotBlank((CharSequence)reporterParameter.getFileOutput()) && !reporterParameter.isConsoleOutput().booleanValue()) continue;
            this.reporterWriter.addReporter(reporterParameter, reporter);
        }
        return reporterList;
    }

    private void logParameters(FileMapperOptions sourceMappingOptions, FileMapperOptions testMappingOptions, List<Reporter> reporterList) {
        Log log = this.getLog();
        log.info((CharSequence)("Invoking TestRunner with: " + this.targetDir));
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug((CharSequence)"Invoking TestRunner with: ");
        log.debug((CharSequence)"reporters=");
        reporterList.forEach(r -> log.debug((CharSequence)r.getTypeName()));
        log.debug((CharSequence)"sources=");
        sourceMappingOptions.getFilePaths().forEach(arg_0 -> ((Log)log).debug(arg_0));
        log.debug((CharSequence)"tests=");
        testMappingOptions.getFilePaths().forEach(arg_0 -> ((Log)log).debug(arg_0));
    }
}

