/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.maven.plugin.helper;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Resource;
import org.codehaus.plexus.util.DirectoryScanner;

public class SQLScannerHelper {
    private SQLScannerHelper() {
    }

    public static List<String> findSQLs(File baseDir, List<Resource> resources, String defaultDirectory, String defaultFilePattern) {
        ArrayList<String> founds = new ArrayList<String>();
        for (Resource resource : resources) {
            if (resource.getDirectory() == null) {
                resource.setDirectory(defaultDirectory);
            }
            if (resource.getIncludes().isEmpty()) {
                resource.getIncludes().add(defaultFilePattern);
            }
            DirectoryScanner scanner = SQLScannerHelper.buildScanner(baseDir.getPath(), resource);
            scanner.scan();
            for (String basename : scanner.getIncludedFiles()) {
                founds.add(baseDir.toURI().relativize(new File(scanner.getBasedir(), basename).toURI()).getPath());
            }
            founds.addAll(Arrays.asList(new String[0]));
        }
        return founds;
    }

    private static DirectoryScanner buildScanner(String baseDir, Resource resource) {
        if (resource != null) {
            File fileBaseDir = new File(baseDir, resource.getDirectory());
            if (!(fileBaseDir.exists() && fileBaseDir.isDirectory() && fileBaseDir.canRead())) {
                throw new IllegalArgumentException(String.format("Invalid <directory> %s in resource. Check your pom.xml", resource.getDirectory()));
            }
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(fileBaseDir.getPath());
            scanner.setIncludes(resource.getIncludes().toArray(new String[0]));
            scanner.setExcludes(resource.getExcludes().toArray(new String[0]));
            return scanner;
        }
        throw new IllegalArgumentException();
    }
}

