/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.maven.plugin.reporter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.utplsql.api.Version;
import org.utplsql.api.outputBuffer.OutputBuffer;
import org.utplsql.api.outputBuffer.OutputBufferProvider;
import org.utplsql.api.reporter.Reporter;
import org.utplsql.maven.plugin.model.ReporterParameter;

public class ReporterWriter {
    private static final Log LOG = new SystemStreamLog();
    private List<Pair<Reporter, ReporterParameter>> listReporters = new ArrayList<Pair<Reporter, ReporterParameter>>();
    private String outputDirectory;
    private Version databaseVersion;

    public ReporterWriter(String outputDirectory, Version databaseVersion) {
        this.outputDirectory = outputDirectory;
        this.databaseVersion = databaseVersion;
    }

    public void addReporter(ReporterParameter parameter, Reporter reporter) {
        this.listReporters.add((Pair<Reporter, ReporterParameter>)Pair.of((Object)reporter, (Object)parameter));
    }

    public void writeReporters(Connection connection) throws MojoExecutionException {
        for (Pair<Reporter, ReporterParameter> pair : this.listReporters) {
            this.writeReports(connection, (Reporter)pair.getLeft(), (ReporterParameter)pair.getRight());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeReports(Connection connection, Reporter reporter, ReporterParameter reporterParameter) throws MojoExecutionException {
        ArrayList<PrintStream> printStreams = new ArrayList<PrintStream>();
        FileOutputStream fout = null;
        try {
            OutputBuffer buffer = OutputBufferProvider.getCompatibleOutputBuffer((Version)this.databaseVersion, (Reporter)reporter, (Connection)connection);
            if (reporterParameter.isFileOutput()) {
                File file = new File(reporterParameter.getFileOutput());
                if (!file.isAbsolute()) {
                    file = new File(this.outputDirectory, reporterParameter.getFileOutput());
                }
                if (!file.getParentFile().exists()) {
                    LOG.debug((CharSequence)("Creating directory for reporter file " + file.getAbsolutePath()));
                    file.getParentFile().mkdirs();
                }
                fout = new FileOutputStream(file);
                LOG.info((CharSequence)String.format("Writing report %s to %s", reporter.getTypeName(), file.getAbsolutePath()));
                printStreams.add(new PrintStream(fout));
            }
            if (reporterParameter.isConsoleOutput().booleanValue()) {
                LOG.info((CharSequence)String.format("Writing report %s to Console", reporter.getTypeName()));
                printStreams.add(System.out);
            }
            buffer.printAvailable(connection, printStreams);
            if (fout == null) return;
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException("Unexpected error opening file ouput ", e);
            }
            catch (Throwable throwable) {
                if (fout == null) throw throwable;
                try {
                    fout.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    LOG.info((CharSequence)String.format("Failed to closing the reporting %s", reporterParameter.getClass()));
                }
                throw throwable;
            }
        }
        try {
            fout.close();
            return;
        }
        catch (IOException e) {
            LOG.info((CharSequence)String.format("Failed to closing the reporting %s", reporterParameter.getClass()));
            return;
        }
    }
}

