/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.tools.xmp;

import com.adobe.xmp.impl.VeraPDFXMPNode;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.verapdf.model.tools.xmp.ValidatorsContainer;

public class SchemasDefinition {
    private Map<QName, String> properties = new HashMap<QName, String>();
    private ValidatorsContainer validator;

    protected SchemasDefinition() {
        this(null);
    }

    protected SchemasDefinition(ValidatorsContainer validator) {
        this.validator = validator;
    }

    public boolean isDefinedProperty(VeraPDFXMPNode node) {
        QName name = new QName(node.getNamespaceURI(), node.getName());
        return this.isDefinedProperty(name);
    }

    protected boolean isDefinedProperty(QName name) {
        return this.properties.containsKey(name);
    }

    public Boolean isCorrespondsDefinedType(VeraPDFXMPNode node) {
        if (this.validator == null) {
            return null;
        }
        String type = this.getType(node);
        return type == null ? null : Boolean.valueOf(this.validator.validate(node, type));
    }

    public ValidatorsContainer getValidatorsContainer() {
        return this.validator;
    }

    protected boolean registerProperty(String namespaceURI, String propertyName, String type) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Argument namespaceURI can not be null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Argument property name can not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument type can not be null");
        }
        if (!this.validator.isKnownType(type)) {
            return false;
        }
        QName name = new QName(namespaceURI, propertyName);
        if (this.properties.containsKey(name)) {
            return false;
        }
        this.properties.put(name, type);
        return true;
    }

    private String getType(VeraPDFXMPNode node) {
        QName name = new QName(node.getNamespaceURI(), node.getName());
        return this.properties.get(name);
    }
}

