/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.validators;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;

@XmlRootElement(name="validatorConfig")
final class ValidatorConfigImpl
implements ValidatorConfig {
    private static final ValidatorConfigImpl defaultConfig = new ValidatorConfigImpl();
    @XmlAttribute
    private final PDFAFlavour flavour;
    @XmlAttribute
    private final boolean recordPasses;
    @XmlAttribute
    private final int maxFails;

    private ValidatorConfigImpl() {
        this(PDFAFlavour.NO_FLAVOUR, false, -1);
    }

    private ValidatorConfigImpl(PDFAFlavour flavour, boolean recordPasses, int maxFails) {
        this.flavour = flavour;
        this.recordPasses = recordPasses;
        this.maxFails = maxFails;
    }

    @Override
    public boolean isRecordPasses() {
        return this.recordPasses;
    }

    @Override
    public int getMaxFails() {
        return this.maxFails;
    }

    @Override
    public PDFAFlavour getFlavour() {
        return this.flavour;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flavour == null ? 0 : this.flavour.hashCode());
        result = 31 * result + this.maxFails;
        result = 31 * result + (this.recordPasses ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidatorConfigImpl)) {
            return false;
        }
        ValidatorConfigImpl other = (ValidatorConfigImpl)obj;
        if (this.flavour != other.flavour) {
            return false;
        }
        if (this.maxFails != other.maxFails) {
            return false;
        }
        return this.recordPasses == other.recordPasses;
    }

    public String toString() {
        return "ValidatorConfigImpl [recordPasses=" + this.recordPasses + ", maxFails=" + this.maxFails + ", flavour=" + (Object)((Object)this.flavour) + "]";
    }

    static ValidatorConfig defaultInstance() {
        return defaultConfig;
    }

    static ValidatorConfig fromValues(PDFAFlavour flavour, boolean recordPasses, int maxFails) {
        return new ValidatorConfigImpl(flavour, recordPasses, maxFails);
    }

    static class Adapter
    extends XmlAdapter<ValidatorConfigImpl, ValidatorConfig> {
        Adapter() {
        }

        public ValidatorConfig unmarshal(ValidatorConfigImpl validationConfigImpl) {
            return validationConfigImpl;
        }

        public ValidatorConfigImpl marshal(ValidatorConfig validationResult) {
            return (ValidatorConfigImpl)validationResult;
        }
    }
}

